package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  ReplaceKeyWith,
  ReplaceKeyPrefixWith,
  HttpRedirectCode,
  HostName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Redirect(
    hostName: Optional[HostName] = Optional.Absent,
    httpRedirectCode: Optional[HttpRedirectCode] = Optional.Absent,
    protocol: Optional[zio.aws.s3.model.Protocol] = Optional.Absent,
    replaceKeyPrefixWith: Optional[ReplaceKeyPrefixWith] = Optional.Absent,
    replaceKeyWith: Optional[ReplaceKeyWith] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Redirect = {
    import Redirect.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Redirect
      .builder()
      .optionallyWith(
        hostName.map(value => HostName.unwrap(value): java.lang.String)
      )(_.hostName)
      .optionallyWith(
        httpRedirectCode.map(value =>
          HttpRedirectCode.unwrap(value): java.lang.String
        )
      )(_.httpRedirectCode)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(
        replaceKeyPrefixWith.map(value =>
          ReplaceKeyPrefixWith.unwrap(value): java.lang.String
        )
      )(_.replaceKeyPrefixWith)
      .optionallyWith(
        replaceKeyWith.map(value =>
          ReplaceKeyWith.unwrap(value): java.lang.String
        )
      )(_.replaceKeyWith)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.Redirect.ReadOnly =
    zio.aws.s3.model.Redirect.wrap(buildAwsValue())
}
object Redirect {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Redirect] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.Redirect = zio.aws.s3.model.Redirect(
      hostName.map(value => value),
      httpRedirectCode.map(value => value),
      protocol.map(value => value),
      replaceKeyPrefixWith.map(value => value),
      replaceKeyWith.map(value => value)
    )
    def hostName: Optional[HostName]
    def httpRedirectCode: Optional[HttpRedirectCode]
    def protocol: Optional[zio.aws.s3.model.Protocol]
    def replaceKeyPrefixWith: Optional[ReplaceKeyPrefixWith]
    def replaceKeyWith: Optional[ReplaceKeyWith]
    def getHostName: ZIO[Any, AwsError, HostName] =
      AwsError.unwrapOptionField("hostName", hostName)
    def getHttpRedirectCode: ZIO[Any, AwsError, HttpRedirectCode] =
      AwsError.unwrapOptionField("httpRedirectCode", httpRedirectCode)
    def getProtocol: ZIO[Any, AwsError, zio.aws.s3.model.Protocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getReplaceKeyPrefixWith: ZIO[Any, AwsError, ReplaceKeyPrefixWith] =
      AwsError.unwrapOptionField("replaceKeyPrefixWith", replaceKeyPrefixWith)
    def getReplaceKeyWith: ZIO[Any, AwsError, ReplaceKeyWith] =
      AwsError.unwrapOptionField("replaceKeyWith", replaceKeyWith)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.Redirect
  ) extends zio.aws.s3.model.Redirect.ReadOnly {
    override val hostName: Optional[HostName] = zio.aws.core.internal
      .optionalFromNullable(impl.hostName())
      .map(value => zio.aws.s3.model.primitives.HostName(value))
    override val httpRedirectCode: Optional[HttpRedirectCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpRedirectCode())
        .map(value => zio.aws.s3.model.primitives.HttpRedirectCode(value))
    override val protocol: Optional[zio.aws.s3.model.Protocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value => zio.aws.s3.model.Protocol.wrap(value))
    override val replaceKeyPrefixWith: Optional[ReplaceKeyPrefixWith] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replaceKeyPrefixWith())
        .map(value => zio.aws.s3.model.primitives.ReplaceKeyPrefixWith(value))
    override val replaceKeyWith: Optional[ReplaceKeyWith] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replaceKeyWith())
        .map(value => zio.aws.s3.model.primitives.ReplaceKeyWith(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Redirect
  ): zio.aws.s3.model.Redirect.ReadOnly = new Wrapper(impl)
}
