package zio.aws.s3.model
import zio.aws.s3.model.primitives.HostName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RedirectAllRequestsTo(
    hostName: HostName,
    protocol: Optional[zio.aws.s3.model.Protocol] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.RedirectAllRequestsTo = {
    import RedirectAllRequestsTo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.RedirectAllRequestsTo
      .builder()
      .hostName(HostName.unwrap(hostName): java.lang.String)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.RedirectAllRequestsTo.ReadOnly =
    zio.aws.s3.model.RedirectAllRequestsTo.wrap(buildAwsValue())
}
object RedirectAllRequestsTo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.RedirectAllRequestsTo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.RedirectAllRequestsTo = zio.aws.s3.model
      .RedirectAllRequestsTo(hostName, protocol.map(value => value))
    def hostName: HostName
    def protocol: Optional[zio.aws.s3.model.Protocol]
    def getHostName: ZIO[Any, Nothing, HostName] = ZIO.succeed(hostName)
    def getProtocol: ZIO[Any, AwsError, zio.aws.s3.model.Protocol] =
      AwsError.unwrapOptionField("protocol", protocol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.RedirectAllRequestsTo
  ) extends zio.aws.s3.model.RedirectAllRequestsTo.ReadOnly {
    override val hostName: HostName =
      zio.aws.s3.model.primitives.HostName(impl.hostName())
    override val protocol: Optional[zio.aws.s3.model.Protocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value => zio.aws.s3.model.Protocol.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.RedirectAllRequestsTo
  ): zio.aws.s3.model.RedirectAllRequestsTo.ReadOnly = new Wrapper(impl)
}
