package zio.aws.s3.model
import scala.jdk.CollectionConverters._
sealed trait RequestCharged {
  def unwrap: software.amazon.awssdk.services.s3.model.RequestCharged
}
object RequestCharged {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.RequestCharged
  ): zio.aws.s3.model.RequestCharged = value match {
    case software.amazon.awssdk.services.s3.model.RequestCharged.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.RequestCharged.REQUESTER =>
      val r = requester
      r
  }
  case object unknownToSdkVersion extends zio.aws.s3.model.RequestCharged {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.RequestCharged =
      software.amazon.awssdk.services.s3.model.RequestCharged.UNKNOWN_TO_SDK_VERSION
  }
  case object requester extends zio.aws.s3.model.RequestCharged {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.RequestCharged =
      software.amazon.awssdk.services.s3.model.RequestCharged.REQUESTER
  }
}
