package zio.aws.s3.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{Description, Days}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class RestoreRequest(
    days: Optional[Days] = Optional.Absent,
    glacierJobParameters: Optional[zio.aws.s3.model.GlacierJobParameters] =
      Optional.Absent,
    `type`: Optional[zio.aws.s3.model.RestoreRequestType] = Optional.Absent,
    tier: Optional[zio.aws.s3.model.Tier] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    selectParameters: Optional[zio.aws.s3.model.SelectParameters] =
      Optional.Absent,
    outputLocation: Optional[zio.aws.s3.model.OutputLocation] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.RestoreRequest = {
    import RestoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.RestoreRequest
      .builder()
      .optionallyWith(days.map(value => Days.unwrap(value): Integer))(_.days)
      .optionallyWith(glacierJobParameters.map(value => value.buildAwsValue()))(
        _.glacierJobParameters
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(tier.map(value => value.unwrap))(_.tier)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(selectParameters.map(value => value.buildAwsValue()))(
        _.selectParameters
      )
      .optionallyWith(outputLocation.map(value => value.buildAwsValue()))(
        _.outputLocation
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.RestoreRequest.ReadOnly =
    zio.aws.s3.model.RestoreRequest.wrap(buildAwsValue())
}
object RestoreRequest {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.RestoreRequest] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.RestoreRequest =
      zio.aws.s3.model.RestoreRequest(
        days.map(value => value),
        glacierJobParameters.map(value => value.asEditable),
        `type`.map(value => value),
        tier.map(value => value),
        description.map(value => value),
        selectParameters.map(value => value.asEditable),
        outputLocation.map(value => value.asEditable)
      )
    def days: Optional[Days]
    def glacierJobParameters
        : Optional[zio.aws.s3.model.GlacierJobParameters.ReadOnly]
    def `type`: Optional[zio.aws.s3.model.RestoreRequestType]
    def tier: Optional[zio.aws.s3.model.Tier]
    def description: Optional[Description]
    def selectParameters: Optional[zio.aws.s3.model.SelectParameters.ReadOnly]
    def outputLocation: Optional[zio.aws.s3.model.OutputLocation.ReadOnly]
    def getDays: ZIO[Any, AwsError, Days] =
      AwsError.unwrapOptionField("days", days)
    def getGlacierJobParameters
        : ZIO[Any, AwsError, zio.aws.s3.model.GlacierJobParameters.ReadOnly] =
      AwsError.unwrapOptionField("glacierJobParameters", glacierJobParameters)
    def getType: ZIO[Any, AwsError, zio.aws.s3.model.RestoreRequestType] =
      AwsError.unwrapOptionField("type", `type`)
    def getTier: ZIO[Any, AwsError, zio.aws.s3.model.Tier] =
      AwsError.unwrapOptionField("tier", tier)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getSelectParameters
        : ZIO[Any, AwsError, zio.aws.s3.model.SelectParameters.ReadOnly] =
      AwsError.unwrapOptionField("selectParameters", selectParameters)
    def getOutputLocation
        : ZIO[Any, AwsError, zio.aws.s3.model.OutputLocation.ReadOnly] =
      AwsError.unwrapOptionField("outputLocation", outputLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.RestoreRequest
  ) extends zio.aws.s3.model.RestoreRequest.ReadOnly {
    override val days: Optional[Days] = zio.aws.core.internal
      .optionalFromNullable(impl.days())
      .map(value => zio.aws.s3.model.primitives.Days(value))
    override val glacierJobParameters
        : Optional[zio.aws.s3.model.GlacierJobParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.glacierJobParameters())
        .map(value => zio.aws.s3.model.GlacierJobParameters.wrap(value))
    override val `type`: Optional[zio.aws.s3.model.RestoreRequestType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.s3.model.RestoreRequestType.wrap(value))
    override val tier: Optional[zio.aws.s3.model.Tier] = zio.aws.core.internal
      .optionalFromNullable(impl.tier())
      .map(value => zio.aws.s3.model.Tier.wrap(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.s3.model.primitives.Description(value))
    override val selectParameters
        : Optional[zio.aws.s3.model.SelectParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.selectParameters())
        .map(value => zio.aws.s3.model.SelectParameters.wrap(value))
    override val outputLocation
        : Optional[zio.aws.s3.model.OutputLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputLocation())
        .map(value => zio.aws.s3.model.OutputLocation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.RestoreRequest
  ): zio.aws.s3.model.RestoreRequest.ReadOnly = new Wrapper(impl)
}
