package zio.aws.s3.model
import zio.aws.s3.model.primitives.SSEKMSKeyId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ServerSideEncryptionByDefault(
    sseAlgorithm: zio.aws.s3.model.ServerSideEncryption,
    kmsMasterKeyID: Optional[SSEKMSKeyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ServerSideEncryptionByDefault = {
    import ServerSideEncryptionByDefault.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ServerSideEncryptionByDefault
      .builder()
      .sseAlgorithm(sseAlgorithm.unwrap)
      .optionallyWith(
        kmsMasterKeyID.map(value => SSEKMSKeyId.unwrap(value): java.lang.String)
      )(_.kmsMasterKeyID)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ServerSideEncryptionByDefault.ReadOnly =
    zio.aws.s3.model.ServerSideEncryptionByDefault.wrap(buildAwsValue())
}
object ServerSideEncryptionByDefault {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ServerSideEncryptionByDefault
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ServerSideEncryptionByDefault =
      zio.aws.s3.model.ServerSideEncryptionByDefault(
        sseAlgorithm,
        kmsMasterKeyID.map(value => value)
      )
    def sseAlgorithm: zio.aws.s3.model.ServerSideEncryption
    def kmsMasterKeyID: Optional[SSEKMSKeyId]
    def getSseAlgorithm
        : ZIO[Any, Nothing, zio.aws.s3.model.ServerSideEncryption] =
      ZIO.succeed(sseAlgorithm)
    def getKmsMasterKeyID: ZIO[Any, AwsError, SSEKMSKeyId] =
      AwsError.unwrapOptionField("kmsMasterKeyID", kmsMasterKeyID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ServerSideEncryptionByDefault
  ) extends zio.aws.s3.model.ServerSideEncryptionByDefault.ReadOnly {
    override val sseAlgorithm: zio.aws.s3.model.ServerSideEncryption =
      zio.aws.s3.model.ServerSideEncryption.wrap(impl.sseAlgorithm())
    override val kmsMasterKeyID: Optional[SSEKMSKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsMasterKeyID())
      .map(value => zio.aws.s3.model.primitives.SSEKMSKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ServerSideEncryptionByDefault
  ): zio.aws.s3.model.ServerSideEncryptionByDefault.ReadOnly = new Wrapper(impl)
}
