package zio.aws.s3.model
import zio.aws.s3.model.primitives.BucketKeyEnabled
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ServerSideEncryptionRule(
    applyServerSideEncryptionByDefault: Optional[
      zio.aws.s3.model.ServerSideEncryptionByDefault
    ] = Optional.Absent,
    bucketKeyEnabled: Optional[BucketKeyEnabled] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ServerSideEncryptionRule = {
    import ServerSideEncryptionRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ServerSideEncryptionRule
      .builder()
      .optionallyWith(
        applyServerSideEncryptionByDefault.map(value => value.buildAwsValue())
      )(_.applyServerSideEncryptionByDefault)
      .optionallyWith(
        bucketKeyEnabled.map(value =>
          BucketKeyEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.bucketKeyEnabled)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ServerSideEncryptionRule.ReadOnly =
    zio.aws.s3.model.ServerSideEncryptionRule.wrap(buildAwsValue())
}
object ServerSideEncryptionRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ServerSideEncryptionRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ServerSideEncryptionRule =
      zio.aws.s3.model.ServerSideEncryptionRule(
        applyServerSideEncryptionByDefault.map(value => value.asEditable),
        bucketKeyEnabled.map(value => value)
      )
    def applyServerSideEncryptionByDefault
        : Optional[zio.aws.s3.model.ServerSideEncryptionByDefault.ReadOnly]
    def bucketKeyEnabled: Optional[BucketKeyEnabled]
    def getApplyServerSideEncryptionByDefault: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.ServerSideEncryptionByDefault.ReadOnly
    ] = AwsError.unwrapOptionField(
      "applyServerSideEncryptionByDefault",
      applyServerSideEncryptionByDefault
    )
    def getBucketKeyEnabled: ZIO[Any, AwsError, BucketKeyEnabled] =
      AwsError.unwrapOptionField("bucketKeyEnabled", bucketKeyEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ServerSideEncryptionRule
  ) extends zio.aws.s3.model.ServerSideEncryptionRule.ReadOnly {
    override val applyServerSideEncryptionByDefault
        : Optional[zio.aws.s3.model.ServerSideEncryptionByDefault.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applyServerSideEncryptionByDefault())
        .map(value =>
          zio.aws.s3.model.ServerSideEncryptionByDefault.wrap(value)
        )
    override val bucketKeyEnabled: Optional[BucketKeyEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bucketKeyEnabled())
        .map(value => zio.aws.s3.model.primitives.BucketKeyEnabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ServerSideEncryptionRule
  ): zio.aws.s3.model.ServerSideEncryptionRule.ReadOnly = new Wrapper(impl)
}
