package zio.aws.s3.model
import zio.aws.s3.model.primitives.{Value, ObjectKey}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Tag(key: ObjectKey, value: Value) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Tag
      .builder()
      .key(ObjectKey.unwrap(key): java.lang.String)
      .value(Value.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.Tag.ReadOnly =
    zio.aws.s3.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Tag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.Tag = zio.aws.s3.model.Tag(key, value)
    def key: ObjectKey
    def value: Value
    def getKey: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, Value] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.Tag
  ) extends zio.aws.s3.model.Tag.ReadOnly {
    override val key: ObjectKey =
      zio.aws.s3.model.primitives.ObjectKey(impl.key())
    override val value: Value = zio.aws.s3.model.primitives.Value(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Tag
  ): zio.aws.s3.model.Tag.ReadOnly = new Wrapper(impl)
}
