package zio.aws.s3.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{Days, Date}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Transition(
    date: Optional[Date] = Optional.Absent,
    days: Optional[Days] = Optional.Absent,
    storageClass: Optional[zio.aws.s3.model.TransitionStorageClass] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Transition = {
    import Transition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Transition
      .builder()
      .optionallyWith(date.map(value => Date.unwrap(value): Instant))(_.date)
      .optionallyWith(days.map(value => Days.unwrap(value): Integer))(_.days)
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.Transition.ReadOnly =
    zio.aws.s3.model.Transition.wrap(buildAwsValue())
}
object Transition {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Transition] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.Transition = zio.aws.s3.model.Transition(
      date.map(value => value),
      days.map(value => value),
      storageClass.map(value => value)
    )
    def date: Optional[Date]
    def days: Optional[Days]
    def storageClass: Optional[zio.aws.s3.model.TransitionStorageClass]
    def getDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("date", date)
    def getDays: ZIO[Any, AwsError, Days] =
      AwsError.unwrapOptionField("days", days)
    def getStorageClass
        : ZIO[Any, AwsError, zio.aws.s3.model.TransitionStorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.Transition
  ) extends zio.aws.s3.model.Transition.ReadOnly {
    override val date: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.date())
      .map(value => zio.aws.s3.model.primitives.Date(value))
    override val days: Optional[Days] = zio.aws.core.internal
      .optionalFromNullable(impl.days())
      .map(value => zio.aws.s3.model.primitives.Days(value))
    override val storageClass
        : Optional[zio.aws.s3.model.TransitionStorageClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageClass())
        .map(value => zio.aws.s3.model.TransitionStorageClass.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Transition
  ): zio.aws.s3.model.Transition.ReadOnly = new Wrapper(impl)
}
