package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  SSECustomerAlgorithm,
  SSECustomerKeyMD5,
  SSEKMSKeyId,
  CopySourceVersionId,
  BucketKeyEnabled
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UploadPartCopyResponse(
    copySourceVersionId: Optional[CopySourceVersionId] = Optional.Absent,
    copyPartResult: Optional[zio.aws.s3.model.CopyPartResult] = Optional.Absent,
    serverSideEncryption: Optional[zio.aws.s3.model.ServerSideEncryption] =
      Optional.Absent,
    sseCustomerAlgorithm: Optional[SSECustomerAlgorithm] = Optional.Absent,
    sseCustomerKeyMD5: Optional[SSECustomerKeyMD5] = Optional.Absent,
    ssekmsKeyId: Optional[SSEKMSKeyId] = Optional.Absent,
    bucketKeyEnabled: Optional[BucketKeyEnabled] = Optional.Absent,
    requestCharged: Optional[zio.aws.s3.model.RequestCharged] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.UploadPartCopyResponse = {
    import UploadPartCopyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.UploadPartCopyResponse
      .builder()
      .optionallyWith(
        copySourceVersionId.map(value =>
          CopySourceVersionId.unwrap(value): java.lang.String
        )
      )(_.copySourceVersionId)
      .optionallyWith(copyPartResult.map(value => value.buildAwsValue()))(
        _.copyPartResult
      )
      .optionallyWith(serverSideEncryption.map(value => value.unwrap))(
        _.serverSideEncryption
      )
      .optionallyWith(
        sseCustomerAlgorithm.map(value =>
          SSECustomerAlgorithm.unwrap(value): java.lang.String
        )
      )(_.sseCustomerAlgorithm)
      .optionallyWith(
        sseCustomerKeyMD5.map(value =>
          SSECustomerKeyMD5.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKeyMD5)
      .optionallyWith(
        ssekmsKeyId.map(value => SSEKMSKeyId.unwrap(value): java.lang.String)
      )(_.ssekmsKeyId)
      .optionallyWith(
        bucketKeyEnabled.map(value =>
          BucketKeyEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.bucketKeyEnabled)
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.UploadPartCopyResponse.ReadOnly =
    zio.aws.s3.model.UploadPartCopyResponse.wrap(buildAwsValue())
}
object UploadPartCopyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.UploadPartCopyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.UploadPartCopyResponse =
      zio.aws.s3.model.UploadPartCopyResponse(
        copySourceVersionId.map(value => value),
        copyPartResult.map(value => value.asEditable),
        serverSideEncryption.map(value => value),
        sseCustomerAlgorithm.map(value => value),
        sseCustomerKeyMD5.map(value => value),
        ssekmsKeyId.map(value => value),
        bucketKeyEnabled.map(value => value),
        requestCharged.map(value => value)
      )
    def copySourceVersionId: Optional[CopySourceVersionId]
    def copyPartResult: Optional[zio.aws.s3.model.CopyPartResult.ReadOnly]
    def serverSideEncryption: Optional[zio.aws.s3.model.ServerSideEncryption]
    def sseCustomerAlgorithm: Optional[SSECustomerAlgorithm]
    def sseCustomerKeyMD5: Optional[SSECustomerKeyMD5]
    def ssekmsKeyId: Optional[SSEKMSKeyId]
    def bucketKeyEnabled: Optional[BucketKeyEnabled]
    def requestCharged: Optional[zio.aws.s3.model.RequestCharged]
    def getCopySourceVersionId: ZIO[Any, AwsError, CopySourceVersionId] =
      AwsError.unwrapOptionField("copySourceVersionId", copySourceVersionId)
    def getCopyPartResult
        : ZIO[Any, AwsError, zio.aws.s3.model.CopyPartResult.ReadOnly] =
      AwsError.unwrapOptionField("copyPartResult", copyPartResult)
    def getServerSideEncryption
        : ZIO[Any, AwsError, zio.aws.s3.model.ServerSideEncryption] =
      AwsError.unwrapOptionField("serverSideEncryption", serverSideEncryption)
    def getSseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField("sseCustomerAlgorithm", sseCustomerAlgorithm)
    def getSseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5)
    def getSsekmsKeyId: ZIO[Any, AwsError, SSEKMSKeyId] =
      AwsError.unwrapOptionField("ssekmsKeyId", ssekmsKeyId)
    def getBucketKeyEnabled: ZIO[Any, AwsError, BucketKeyEnabled] =
      AwsError.unwrapOptionField("bucketKeyEnabled", bucketKeyEnabled)
    def getRequestCharged: ZIO[Any, AwsError, zio.aws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestCharged)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.UploadPartCopyResponse
  ) extends zio.aws.s3.model.UploadPartCopyResponse.ReadOnly {
    override val copySourceVersionId: Optional[CopySourceVersionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copySourceVersionId())
        .map(value => zio.aws.s3.model.primitives.CopySourceVersionId(value))
    override val copyPartResult
        : Optional[zio.aws.s3.model.CopyPartResult.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copyPartResult())
        .map(value => zio.aws.s3.model.CopyPartResult.wrap(value))
    override val serverSideEncryption
        : Optional[zio.aws.s3.model.ServerSideEncryption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverSideEncryption())
        .map(value => zio.aws.s3.model.ServerSideEncryption.wrap(value))
    override val sseCustomerAlgorithm: Optional[SSECustomerAlgorithm] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerAlgorithm())
        .map(value => zio.aws.s3.model.primitives.SSECustomerAlgorithm(value))
    override val sseCustomerKeyMD5: Optional[SSECustomerKeyMD5] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerKeyMD5())
        .map(value => zio.aws.s3.model.primitives.SSECustomerKeyMD5(value))
    override val ssekmsKeyId: Optional[SSEKMSKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.ssekmsKeyId())
      .map(value => zio.aws.s3.model.primitives.SSEKMSKeyId(value))
    override val bucketKeyEnabled: Optional[BucketKeyEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bucketKeyEnabled())
        .map(value => zio.aws.s3.model.primitives.BucketKeyEnabled(value))
    override val requestCharged: Optional[zio.aws.s3.model.RequestCharged] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestCharged())
        .map(value => zio.aws.s3.model.RequestCharged.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.UploadPartCopyResponse
  ): zio.aws.s3.model.UploadPartCopyResponse.ReadOnly = new Wrapper(impl)
}
