package zio.aws.s3.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{
  SSECustomerKey,
  ContentMD5,
  ContentLength,
  AccountId,
  SSECustomerAlgorithm,
  SSECustomerKeyMD5,
  ChecksumSHA256,
  ChecksumCRC32C,
  ObjectKey,
  ChecksumCRC32,
  ChecksumSHA1,
  BucketName,
  PartNumber,
  MultipartUploadId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UploadPartRequest(
    bucket: BucketName,
    contentLength: Optional[ContentLength] = Optional.Absent,
    contentMD5: Optional[ContentMD5] = Optional.Absent,
    checksumAlgorithm: Optional[zio.aws.s3.model.ChecksumAlgorithm] =
      Optional.Absent,
    checksumCRC32: Optional[ChecksumCRC32] = Optional.Absent,
    checksumCRC32C: Optional[ChecksumCRC32C] = Optional.Absent,
    checksumSHA1: Optional[ChecksumSHA1] = Optional.Absent,
    checksumSHA256: Optional[ChecksumSHA256] = Optional.Absent,
    key: ObjectKey,
    partNumber: PartNumber,
    uploadId: MultipartUploadId,
    sseCustomerAlgorithm: Optional[SSECustomerAlgorithm] = Optional.Absent,
    sseCustomerKey: Optional[SSECustomerKey] = Optional.Absent,
    sseCustomerKeyMD5: Optional[SSECustomerKeyMD5] = Optional.Absent,
    requestPayer: Optional[zio.aws.s3.model.RequestPayer] = Optional.Absent,
    expectedBucketOwner: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.UploadPartRequest = {
    import UploadPartRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.UploadPartRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        contentLength.map(value => ContentLength.unwrap(value): java.lang.Long)
      )(_.contentLength)
      .optionallyWith(
        contentMD5.map(value => ContentMD5.unwrap(value): java.lang.String)
      )(_.contentMD5)
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .optionallyWith(
        checksumCRC32.map(value =>
          ChecksumCRC32.unwrap(value): java.lang.String
        )
      )(_.checksumCRC32)
      .optionallyWith(
        checksumCRC32C.map(value =>
          ChecksumCRC32C.unwrap(value): java.lang.String
        )
      )(_.checksumCRC32C)
      .optionallyWith(
        checksumSHA1.map(value => ChecksumSHA1.unwrap(value): java.lang.String)
      )(_.checksumSHA1)
      .optionallyWith(
        checksumSHA256.map(value =>
          ChecksumSHA256.unwrap(value): java.lang.String
        )
      )(_.checksumSHA256)
      .key(ObjectKey.unwrap(key): java.lang.String)
      .partNumber(PartNumber.unwrap(partNumber): Integer)
      .uploadId(MultipartUploadId.unwrap(uploadId): java.lang.String)
      .optionallyWith(
        sseCustomerAlgorithm.map(value =>
          SSECustomerAlgorithm.unwrap(value): java.lang.String
        )
      )(_.sseCustomerAlgorithm)
      .optionallyWith(
        sseCustomerKey.map(value =>
          SSECustomerKey.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKey)
      .optionallyWith(
        sseCustomerKeyMD5.map(value =>
          SSECustomerKeyMD5.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKeyMD5)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.UploadPartRequest.ReadOnly =
    zio.aws.s3.model.UploadPartRequest.wrap(buildAwsValue())
}
object UploadPartRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.UploadPartRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.UploadPartRequest =
      zio.aws.s3.model.UploadPartRequest(
        bucket,
        contentLength.map(value => value),
        contentMD5.map(value => value),
        checksumAlgorithm.map(value => value),
        checksumCRC32.map(value => value),
        checksumCRC32C.map(value => value),
        checksumSHA1.map(value => value),
        checksumSHA256.map(value => value),
        key,
        partNumber,
        uploadId,
        sseCustomerAlgorithm.map(value => value),
        sseCustomerKey.map(value => value),
        sseCustomerKeyMD5.map(value => value),
        requestPayer.map(value => value),
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def contentLength: Optional[ContentLength]
    def contentMD5: Optional[ContentMD5]
    def checksumAlgorithm: Optional[zio.aws.s3.model.ChecksumAlgorithm]
    def checksumCRC32: Optional[ChecksumCRC32]
    def checksumCRC32C: Optional[ChecksumCRC32C]
    def checksumSHA1: Optional[ChecksumSHA1]
    def checksumSHA256: Optional[ChecksumSHA256]
    def key: ObjectKey
    def partNumber: PartNumber
    def uploadId: MultipartUploadId
    def sseCustomerAlgorithm: Optional[SSECustomerAlgorithm]
    def sseCustomerKey: Optional[SSECustomerKey]
    def sseCustomerKeyMD5: Optional[SSECustomerKeyMD5]
    def requestPayer: Optional[zio.aws.s3.model.RequestPayer]
    def expectedBucketOwner: Optional[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getContentLength: ZIO[Any, AwsError, ContentLength] =
      AwsError.unwrapOptionField("contentLength", contentLength)
    def getContentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5)
    def getChecksumAlgorithm
        : ZIO[Any, AwsError, zio.aws.s3.model.ChecksumAlgorithm] =
      AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithm)
    def getChecksumCRC32: ZIO[Any, AwsError, ChecksumCRC32] =
      AwsError.unwrapOptionField("checksumCRC32", checksumCRC32)
    def getChecksumCRC32C: ZIO[Any, AwsError, ChecksumCRC32C] =
      AwsError.unwrapOptionField("checksumCRC32C", checksumCRC32C)
    def getChecksumSHA1: ZIO[Any, AwsError, ChecksumSHA1] =
      AwsError.unwrapOptionField("checksumSHA1", checksumSHA1)
    def getChecksumSHA256: ZIO[Any, AwsError, ChecksumSHA256] =
      AwsError.unwrapOptionField("checksumSHA256", checksumSHA256)
    def getKey: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(key)
    def getPartNumber: ZIO[Any, Nothing, PartNumber] = ZIO.succeed(partNumber)
    def getUploadId: ZIO[Any, Nothing, MultipartUploadId] =
      ZIO.succeed(uploadId)
    def getSseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField("sseCustomerAlgorithm", sseCustomerAlgorithm)
    def getSseCustomerKey: ZIO[Any, AwsError, SSECustomerKey] =
      AwsError.unwrapOptionField("sseCustomerKey", sseCustomerKey)
    def getSseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5)
    def getRequestPayer: ZIO[Any, AwsError, zio.aws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayer)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.UploadPartRequest
  ) extends zio.aws.s3.model.UploadPartRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val contentLength: Optional[ContentLength] = zio.aws.core.internal
      .optionalFromNullable(impl.contentLength())
      .map(value => zio.aws.s3.model.primitives.ContentLength(value))
    override val contentMD5: Optional[ContentMD5] = zio.aws.core.internal
      .optionalFromNullable(impl.contentMD5())
      .map(value => zio.aws.s3.model.primitives.ContentMD5(value))
    override val checksumAlgorithm
        : Optional[zio.aws.s3.model.ChecksumAlgorithm] = zio.aws.core.internal
      .optionalFromNullable(impl.checksumAlgorithm())
      .map(value => zio.aws.s3.model.ChecksumAlgorithm.wrap(value))
    override val checksumCRC32: Optional[ChecksumCRC32] = zio.aws.core.internal
      .optionalFromNullable(impl.checksumCRC32())
      .map(value => zio.aws.s3.model.primitives.ChecksumCRC32(value))
    override val checksumCRC32C: Optional[ChecksumCRC32C] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checksumCRC32C())
        .map(value => zio.aws.s3.model.primitives.ChecksumCRC32C(value))
    override val checksumSHA1: Optional[ChecksumSHA1] = zio.aws.core.internal
      .optionalFromNullable(impl.checksumSHA1())
      .map(value => zio.aws.s3.model.primitives.ChecksumSHA1(value))
    override val checksumSHA256: Optional[ChecksumSHA256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checksumSHA256())
        .map(value => zio.aws.s3.model.primitives.ChecksumSHA256(value))
    override val key: ObjectKey =
      zio.aws.s3.model.primitives.ObjectKey(impl.key())
    override val partNumber: PartNumber =
      zio.aws.s3.model.primitives.PartNumber(impl.partNumber())
    override val uploadId: MultipartUploadId =
      zio.aws.s3.model.primitives.MultipartUploadId(impl.uploadId())
    override val sseCustomerAlgorithm: Optional[SSECustomerAlgorithm] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerAlgorithm())
        .map(value => zio.aws.s3.model.primitives.SSECustomerAlgorithm(value))
    override val sseCustomerKey: Optional[SSECustomerKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerKey())
        .map(value => zio.aws.s3.model.primitives.SSECustomerKey(value))
    override val sseCustomerKeyMD5: Optional[SSECustomerKeyMD5] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerKeyMD5())
        .map(value => zio.aws.s3.model.primitives.SSECustomerKeyMD5(value))
    override val requestPayer: Optional[zio.aws.s3.model.RequestPayer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestPayer())
        .map(value => zio.aws.s3.model.RequestPayer.wrap(value))
    override val expectedBucketOwner: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedBucketOwner())
        .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.UploadPartRequest
  ): zio.aws.s3.model.UploadPartRequest.ReadOnly = new Wrapper(impl)
}
