package zio.aws.s3.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{
  ContentType,
  ErrorMessage,
  ETag,
  CacheControl,
  GetObjectResponseStatusCode,
  TagCount,
  AcceptRanges,
  ContentDisposition,
  ContentLanguage,
  Expiration,
  ContentLength,
  PartsCount,
  SSECustomerAlgorithm,
  SSECustomerKeyMD5,
  DeleteMarker,
  ChecksumSHA256,
  LastModified,
  Expires,
  ContentEncoding,
  ChecksumCRC32C,
  ChecksumCRC32,
  ErrorCode,
  RequestToken,
  MissingMeta,
  ChecksumSHA1,
  SSEKMSKeyId,
  MetadataValue,
  RequestRoute,
  ObjectLockRetainUntilDate,
  Restore,
  ObjectVersionId,
  MetadataKey,
  BucketKeyEnabled,
  ContentRange
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class WriteGetObjectResponseRequest(
    requestRoute: RequestRoute,
    requestToken: RequestToken,
    statusCode: Optional[GetObjectResponseStatusCode] = Optional.Absent,
    errorCode: Optional[ErrorCode] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent,
    acceptRanges: Optional[AcceptRanges] = Optional.Absent,
    cacheControl: Optional[CacheControl] = Optional.Absent,
    contentDisposition: Optional[ContentDisposition] = Optional.Absent,
    contentEncoding: Optional[ContentEncoding] = Optional.Absent,
    contentLanguage: Optional[ContentLanguage] = Optional.Absent,
    contentLength: Optional[ContentLength] = Optional.Absent,
    contentRange: Optional[ContentRange] = Optional.Absent,
    contentType: Optional[ContentType] = Optional.Absent,
    checksumCRC32: Optional[ChecksumCRC32] = Optional.Absent,
    checksumCRC32C: Optional[ChecksumCRC32C] = Optional.Absent,
    checksumSHA1: Optional[ChecksumSHA1] = Optional.Absent,
    checksumSHA256: Optional[ChecksumSHA256] = Optional.Absent,
    deleteMarker: Optional[DeleteMarker] = Optional.Absent,
    eTag: Optional[ETag] = Optional.Absent,
    expires: Optional[Expires] = Optional.Absent,
    expiration: Optional[Expiration] = Optional.Absent,
    lastModified: Optional[LastModified] = Optional.Absent,
    missingMeta: Optional[MissingMeta] = Optional.Absent,
    metadata: Optional[Map[MetadataKey, MetadataValue]] = Optional.Absent,
    objectLockMode: Optional[zio.aws.s3.model.ObjectLockMode] = Optional.Absent,
    objectLockLegalHoldStatus: Optional[
      zio.aws.s3.model.ObjectLockLegalHoldStatus
    ] = Optional.Absent,
    objectLockRetainUntilDate: Optional[ObjectLockRetainUntilDate] =
      Optional.Absent,
    partsCount: Optional[PartsCount] = Optional.Absent,
    replicationStatus: Optional[zio.aws.s3.model.ReplicationStatus] =
      Optional.Absent,
    requestCharged: Optional[zio.aws.s3.model.RequestCharged] = Optional.Absent,
    restore: Optional[Restore] = Optional.Absent,
    serverSideEncryption: Optional[zio.aws.s3.model.ServerSideEncryption] =
      Optional.Absent,
    sseCustomerAlgorithm: Optional[SSECustomerAlgorithm] = Optional.Absent,
    ssekmsKeyId: Optional[SSEKMSKeyId] = Optional.Absent,
    sseCustomerKeyMD5: Optional[SSECustomerKeyMD5] = Optional.Absent,
    storageClass: Optional[zio.aws.s3.model.StorageClass] = Optional.Absent,
    tagCount: Optional[TagCount] = Optional.Absent,
    versionId: Optional[ObjectVersionId] = Optional.Absent,
    bucketKeyEnabled: Optional[BucketKeyEnabled] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.WriteGetObjectResponseRequest = {
    import WriteGetObjectResponseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.WriteGetObjectResponseRequest
      .builder()
      .requestRoute(RequestRoute.unwrap(requestRoute): java.lang.String)
      .requestToken(RequestToken.unwrap(requestToken): java.lang.String)
      .optionallyWith(
        statusCode.map(value =>
          GetObjectResponseStatusCode.unwrap(value): Integer
        )
      )(_.statusCode)
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(
        acceptRanges.map(value => AcceptRanges.unwrap(value): java.lang.String)
      )(_.acceptRanges)
      .optionallyWith(
        cacheControl.map(value => CacheControl.unwrap(value): java.lang.String)
      )(_.cacheControl)
      .optionallyWith(
        contentDisposition.map(value =>
          ContentDisposition.unwrap(value): java.lang.String
        )
      )(_.contentDisposition)
      .optionallyWith(
        contentEncoding.map(value =>
          ContentEncoding.unwrap(value): java.lang.String
        )
      )(_.contentEncoding)
      .optionallyWith(
        contentLanguage.map(value =>
          ContentLanguage.unwrap(value): java.lang.String
        )
      )(_.contentLanguage)
      .optionallyWith(
        contentLength.map(value => ContentLength.unwrap(value): java.lang.Long)
      )(_.contentLength)
      .optionallyWith(
        contentRange.map(value => ContentRange.unwrap(value): java.lang.String)
      )(_.contentRange)
      .optionallyWith(
        contentType.map(value => ContentType.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(
        checksumCRC32.map(value =>
          ChecksumCRC32.unwrap(value): java.lang.String
        )
      )(_.checksumCRC32)
      .optionallyWith(
        checksumCRC32C.map(value =>
          ChecksumCRC32C.unwrap(value): java.lang.String
        )
      )(_.checksumCRC32C)
      .optionallyWith(
        checksumSHA1.map(value => ChecksumSHA1.unwrap(value): java.lang.String)
      )(_.checksumSHA1)
      .optionallyWith(
        checksumSHA256.map(value =>
          ChecksumSHA256.unwrap(value): java.lang.String
        )
      )(_.checksumSHA256)
      .optionallyWith(
        deleteMarker.map(value => DeleteMarker.unwrap(value): java.lang.Boolean)
      )(_.deleteMarker)
      .optionallyWith(eTag.map(value => ETag.unwrap(value): java.lang.String))(
        _.eTag
      )
      .optionallyWith(expires.map(value => Expires.unwrap(value): Instant))(
        _.expires
      )
      .optionallyWith(
        expiration.map(value => Expiration.unwrap(value): java.lang.String)
      )(_.expiration)
      .optionallyWith(
        lastModified.map(value => LastModified.unwrap(value): Instant)
      )(_.lastModified)
      .optionallyWith(
        missingMeta.map(value => MissingMeta.unwrap(value): Integer)
      )(_.missingMeta)
      .optionallyWith(
        metadata.map(value =>
          value
            .map({ case (key, value) =>
              (MetadataKey.unwrap(key): java.lang.String) -> (MetadataValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.metadata)
      .optionallyWith(objectLockMode.map(value => value.unwrap))(
        _.objectLockMode
      )
      .optionallyWith(objectLockLegalHoldStatus.map(value => value.unwrap))(
        _.objectLockLegalHoldStatus
      )
      .optionallyWith(
        objectLockRetainUntilDate.map(value =>
          ObjectLockRetainUntilDate.unwrap(value): Instant
        )
      )(_.objectLockRetainUntilDate)
      .optionallyWith(
        partsCount.map(value => PartsCount.unwrap(value): Integer)
      )(_.partsCount)
      .optionallyWith(replicationStatus.map(value => value.unwrap))(
        _.replicationStatus
      )
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .optionallyWith(
        restore.map(value => Restore.unwrap(value): java.lang.String)
      )(_.restore)
      .optionallyWith(serverSideEncryption.map(value => value.unwrap))(
        _.serverSideEncryption
      )
      .optionallyWith(
        sseCustomerAlgorithm.map(value =>
          SSECustomerAlgorithm.unwrap(value): java.lang.String
        )
      )(_.sseCustomerAlgorithm)
      .optionallyWith(
        ssekmsKeyId.map(value => SSEKMSKeyId.unwrap(value): java.lang.String)
      )(_.ssekmsKeyId)
      .optionallyWith(
        sseCustomerKeyMD5.map(value =>
          SSECustomerKeyMD5.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKeyMD5)
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(tagCount.map(value => TagCount.unwrap(value): Integer))(
        _.tagCount
      )
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(
        bucketKeyEnabled.map(value =>
          BucketKeyEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.bucketKeyEnabled)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.WriteGetObjectResponseRequest.ReadOnly =
    zio.aws.s3.model.WriteGetObjectResponseRequest.wrap(buildAwsValue())
}
object WriteGetObjectResponseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.WriteGetObjectResponseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.WriteGetObjectResponseRequest =
      zio.aws.s3.model.WriteGetObjectResponseRequest(
        requestRoute,
        requestToken,
        statusCode.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value),
        acceptRanges.map(value => value),
        cacheControl.map(value => value),
        contentDisposition.map(value => value),
        contentEncoding.map(value => value),
        contentLanguage.map(value => value),
        contentLength.map(value => value),
        contentRange.map(value => value),
        contentType.map(value => value),
        checksumCRC32.map(value => value),
        checksumCRC32C.map(value => value),
        checksumSHA1.map(value => value),
        checksumSHA256.map(value => value),
        deleteMarker.map(value => value),
        eTag.map(value => value),
        expires.map(value => value),
        expiration.map(value => value),
        lastModified.map(value => value),
        missingMeta.map(value => value),
        metadata.map(value => value),
        objectLockMode.map(value => value),
        objectLockLegalHoldStatus.map(value => value),
        objectLockRetainUntilDate.map(value => value),
        partsCount.map(value => value),
        replicationStatus.map(value => value),
        requestCharged.map(value => value),
        restore.map(value => value),
        serverSideEncryption.map(value => value),
        sseCustomerAlgorithm.map(value => value),
        ssekmsKeyId.map(value => value),
        sseCustomerKeyMD5.map(value => value),
        storageClass.map(value => value),
        tagCount.map(value => value),
        versionId.map(value => value),
        bucketKeyEnabled.map(value => value)
      )
    def requestRoute: RequestRoute
    def requestToken: RequestToken
    def statusCode: Optional[GetObjectResponseStatusCode]
    def errorCode: Optional[ErrorCode]
    def errorMessage: Optional[ErrorMessage]
    def acceptRanges: Optional[AcceptRanges]
    def cacheControl: Optional[CacheControl]
    def contentDisposition: Optional[ContentDisposition]
    def contentEncoding: Optional[ContentEncoding]
    def contentLanguage: Optional[ContentLanguage]
    def contentLength: Optional[ContentLength]
    def contentRange: Optional[ContentRange]
    def contentType: Optional[ContentType]
    def checksumCRC32: Optional[ChecksumCRC32]
    def checksumCRC32C: Optional[ChecksumCRC32C]
    def checksumSHA1: Optional[ChecksumSHA1]
    def checksumSHA256: Optional[ChecksumSHA256]
    def deleteMarker: Optional[DeleteMarker]
    def eTag: Optional[ETag]
    def expires: Optional[Expires]
    def expiration: Optional[Expiration]
    def lastModified: Optional[LastModified]
    def missingMeta: Optional[MissingMeta]
    def metadata: Optional[Map[MetadataKey, MetadataValue]]
    def objectLockMode: Optional[zio.aws.s3.model.ObjectLockMode]
    def objectLockLegalHoldStatus
        : Optional[zio.aws.s3.model.ObjectLockLegalHoldStatus]
    def objectLockRetainUntilDate: Optional[ObjectLockRetainUntilDate]
    def partsCount: Optional[PartsCount]
    def replicationStatus: Optional[zio.aws.s3.model.ReplicationStatus]
    def requestCharged: Optional[zio.aws.s3.model.RequestCharged]
    def restore: Optional[Restore]
    def serverSideEncryption: Optional[zio.aws.s3.model.ServerSideEncryption]
    def sseCustomerAlgorithm: Optional[SSECustomerAlgorithm]
    def ssekmsKeyId: Optional[SSEKMSKeyId]
    def sseCustomerKeyMD5: Optional[SSECustomerKeyMD5]
    def storageClass: Optional[zio.aws.s3.model.StorageClass]
    def tagCount: Optional[TagCount]
    def versionId: Optional[ObjectVersionId]
    def bucketKeyEnabled: Optional[BucketKeyEnabled]
    def getRequestRoute: ZIO[Any, Nothing, RequestRoute] =
      ZIO.succeed(requestRoute)
    def getRequestToken: ZIO[Any, Nothing, RequestToken] =
      ZIO.succeed(requestToken)
    def getStatusCode: ZIO[Any, AwsError, GetObjectResponseStatusCode] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getAcceptRanges: ZIO[Any, AwsError, AcceptRanges] =
      AwsError.unwrapOptionField("acceptRanges", acceptRanges)
    def getCacheControl: ZIO[Any, AwsError, CacheControl] =
      AwsError.unwrapOptionField("cacheControl", cacheControl)
    def getContentDisposition: ZIO[Any, AwsError, ContentDisposition] =
      AwsError.unwrapOptionField("contentDisposition", contentDisposition)
    def getContentEncoding: ZIO[Any, AwsError, ContentEncoding] =
      AwsError.unwrapOptionField("contentEncoding", contentEncoding)
    def getContentLanguage: ZIO[Any, AwsError, ContentLanguage] =
      AwsError.unwrapOptionField("contentLanguage", contentLanguage)
    def getContentLength: ZIO[Any, AwsError, ContentLength] =
      AwsError.unwrapOptionField("contentLength", contentLength)
    def getContentRange: ZIO[Any, AwsError, ContentRange] =
      AwsError.unwrapOptionField("contentRange", contentRange)
    def getContentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getChecksumCRC32: ZIO[Any, AwsError, ChecksumCRC32] =
      AwsError.unwrapOptionField("checksumCRC32", checksumCRC32)
    def getChecksumCRC32C: ZIO[Any, AwsError, ChecksumCRC32C] =
      AwsError.unwrapOptionField("checksumCRC32C", checksumCRC32C)
    def getChecksumSHA1: ZIO[Any, AwsError, ChecksumSHA1] =
      AwsError.unwrapOptionField("checksumSHA1", checksumSHA1)
    def getChecksumSHA256: ZIO[Any, AwsError, ChecksumSHA256] =
      AwsError.unwrapOptionField("checksumSHA256", checksumSHA256)
    def getDeleteMarker: ZIO[Any, AwsError, DeleteMarker] =
      AwsError.unwrapOptionField("deleteMarker", deleteMarker)
    def getETag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getExpires: ZIO[Any, AwsError, Expires] =
      AwsError.unwrapOptionField("expires", expires)
    def getExpiration: ZIO[Any, AwsError, Expiration] =
      AwsError.unwrapOptionField("expiration", expiration)
    def getLastModified: ZIO[Any, AwsError, LastModified] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getMissingMeta: ZIO[Any, AwsError, MissingMeta] =
      AwsError.unwrapOptionField("missingMeta", missingMeta)
    def getMetadata: ZIO[Any, AwsError, Map[MetadataKey, MetadataValue]] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getObjectLockMode: ZIO[Any, AwsError, zio.aws.s3.model.ObjectLockMode] =
      AwsError.unwrapOptionField("objectLockMode", objectLockMode)
    def getObjectLockLegalHoldStatus
        : ZIO[Any, AwsError, zio.aws.s3.model.ObjectLockLegalHoldStatus] =
      AwsError.unwrapOptionField(
        "objectLockLegalHoldStatus",
        objectLockLegalHoldStatus
      )
    def getObjectLockRetainUntilDate
        : ZIO[Any, AwsError, ObjectLockRetainUntilDate] = AwsError
      .unwrapOptionField("objectLockRetainUntilDate", objectLockRetainUntilDate)
    def getPartsCount: ZIO[Any, AwsError, PartsCount] =
      AwsError.unwrapOptionField("partsCount", partsCount)
    def getReplicationStatus
        : ZIO[Any, AwsError, zio.aws.s3.model.ReplicationStatus] =
      AwsError.unwrapOptionField("replicationStatus", replicationStatus)
    def getRequestCharged: ZIO[Any, AwsError, zio.aws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestCharged)
    def getRestore: ZIO[Any, AwsError, Restore] =
      AwsError.unwrapOptionField("restore", restore)
    def getServerSideEncryption
        : ZIO[Any, AwsError, zio.aws.s3.model.ServerSideEncryption] =
      AwsError.unwrapOptionField("serverSideEncryption", serverSideEncryption)
    def getSseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField("sseCustomerAlgorithm", sseCustomerAlgorithm)
    def getSsekmsKeyId: ZIO[Any, AwsError, SSEKMSKeyId] =
      AwsError.unwrapOptionField("ssekmsKeyId", ssekmsKeyId)
    def getSseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5)
    def getStorageClass: ZIO[Any, AwsError, zio.aws.s3.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getTagCount: ZIO[Any, AwsError, TagCount] =
      AwsError.unwrapOptionField("tagCount", tagCount)
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getBucketKeyEnabled: ZIO[Any, AwsError, BucketKeyEnabled] =
      AwsError.unwrapOptionField("bucketKeyEnabled", bucketKeyEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.WriteGetObjectResponseRequest
  ) extends zio.aws.s3.model.WriteGetObjectResponseRequest.ReadOnly {
    override val requestRoute: RequestRoute =
      zio.aws.s3.model.primitives.RequestRoute(impl.requestRoute())
    override val requestToken: RequestToken =
      zio.aws.s3.model.primitives.RequestToken(impl.requestToken())
    override val statusCode: Optional[GetObjectResponseStatusCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusCode())
        .map(value =>
          zio.aws.s3.model.primitives.GetObjectResponseStatusCode(value)
        )
    override val errorCode: Optional[ErrorCode] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => zio.aws.s3.model.primitives.ErrorCode(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.s3.model.primitives.ErrorMessage(value))
    override val acceptRanges: Optional[AcceptRanges] = zio.aws.core.internal
      .optionalFromNullable(impl.acceptRanges())
      .map(value => zio.aws.s3.model.primitives.AcceptRanges(value))
    override val cacheControl: Optional[CacheControl] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheControl())
      .map(value => zio.aws.s3.model.primitives.CacheControl(value))
    override val contentDisposition: Optional[ContentDisposition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentDisposition())
        .map(value => zio.aws.s3.model.primitives.ContentDisposition(value))
    override val contentEncoding: Optional[ContentEncoding] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentEncoding())
        .map(value => zio.aws.s3.model.primitives.ContentEncoding(value))
    override val contentLanguage: Optional[ContentLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentLanguage())
        .map(value => zio.aws.s3.model.primitives.ContentLanguage(value))
    override val contentLength: Optional[ContentLength] = zio.aws.core.internal
      .optionalFromNullable(impl.contentLength())
      .map(value => zio.aws.s3.model.primitives.ContentLength(value))
    override val contentRange: Optional[ContentRange] = zio.aws.core.internal
      .optionalFromNullable(impl.contentRange())
      .map(value => zio.aws.s3.model.primitives.ContentRange(value))
    override val contentType: Optional[ContentType] = zio.aws.core.internal
      .optionalFromNullable(impl.contentType())
      .map(value => zio.aws.s3.model.primitives.ContentType(value))
    override val checksumCRC32: Optional[ChecksumCRC32] = zio.aws.core.internal
      .optionalFromNullable(impl.checksumCRC32())
      .map(value => zio.aws.s3.model.primitives.ChecksumCRC32(value))
    override val checksumCRC32C: Optional[ChecksumCRC32C] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checksumCRC32C())
        .map(value => zio.aws.s3.model.primitives.ChecksumCRC32C(value))
    override val checksumSHA1: Optional[ChecksumSHA1] = zio.aws.core.internal
      .optionalFromNullable(impl.checksumSHA1())
      .map(value => zio.aws.s3.model.primitives.ChecksumSHA1(value))
    override val checksumSHA256: Optional[ChecksumSHA256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checksumSHA256())
        .map(value => zio.aws.s3.model.primitives.ChecksumSHA256(value))
    override val deleteMarker: Optional[DeleteMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteMarker())
      .map(value => zio.aws.s3.model.primitives.DeleteMarker(value))
    override val eTag: Optional[ETag] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => zio.aws.s3.model.primitives.ETag(value))
    override val expires: Optional[Expires] = zio.aws.core.internal
      .optionalFromNullable(impl.expires())
      .map(value => zio.aws.s3.model.primitives.Expires(value))
    override val expiration: Optional[Expiration] = zio.aws.core.internal
      .optionalFromNullable(impl.expiration())
      .map(value => zio.aws.s3.model.primitives.Expiration(value))
    override val lastModified: Optional[LastModified] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModified())
      .map(value => zio.aws.s3.model.primitives.LastModified(value))
    override val missingMeta: Optional[MissingMeta] = zio.aws.core.internal
      .optionalFromNullable(impl.missingMeta())
      .map(value => zio.aws.s3.model.primitives.MissingMeta(value))
    override val metadata: Optional[Map[MetadataKey, MetadataValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.s3.model.primitives.MetadataKey(
                key
              ) -> zio.aws.s3.model.primitives.MetadataValue(value)
            })
            .toMap
        )
    override val objectLockMode: Optional[zio.aws.s3.model.ObjectLockMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectLockMode())
        .map(value => zio.aws.s3.model.ObjectLockMode.wrap(value))
    override val objectLockLegalHoldStatus
        : Optional[zio.aws.s3.model.ObjectLockLegalHoldStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectLockLegalHoldStatus())
        .map(value => zio.aws.s3.model.ObjectLockLegalHoldStatus.wrap(value))
    override val objectLockRetainUntilDate
        : Optional[ObjectLockRetainUntilDate] = zio.aws.core.internal
      .optionalFromNullable(impl.objectLockRetainUntilDate())
      .map(value =>
        zio.aws.s3.model.primitives.ObjectLockRetainUntilDate(value)
      )
    override val partsCount: Optional[PartsCount] = zio.aws.core.internal
      .optionalFromNullable(impl.partsCount())
      .map(value => zio.aws.s3.model.primitives.PartsCount(value))
    override val replicationStatus
        : Optional[zio.aws.s3.model.ReplicationStatus] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationStatus())
      .map(value => zio.aws.s3.model.ReplicationStatus.wrap(value))
    override val requestCharged: Optional[zio.aws.s3.model.RequestCharged] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestCharged())
        .map(value => zio.aws.s3.model.RequestCharged.wrap(value))
    override val restore: Optional[Restore] = zio.aws.core.internal
      .optionalFromNullable(impl.restore())
      .map(value => zio.aws.s3.model.primitives.Restore(value))
    override val serverSideEncryption
        : Optional[zio.aws.s3.model.ServerSideEncryption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverSideEncryption())
        .map(value => zio.aws.s3.model.ServerSideEncryption.wrap(value))
    override val sseCustomerAlgorithm: Optional[SSECustomerAlgorithm] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerAlgorithm())
        .map(value => zio.aws.s3.model.primitives.SSECustomerAlgorithm(value))
    override val ssekmsKeyId: Optional[SSEKMSKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.ssekmsKeyId())
      .map(value => zio.aws.s3.model.primitives.SSEKMSKeyId(value))
    override val sseCustomerKeyMD5: Optional[SSECustomerKeyMD5] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerKeyMD5())
        .map(value => zio.aws.s3.model.primitives.SSECustomerKeyMD5(value))
    override val storageClass: Optional[zio.aws.s3.model.StorageClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageClass())
        .map(value => zio.aws.s3.model.StorageClass.wrap(value))
    override val tagCount: Optional[TagCount] = zio.aws.core.internal
      .optionalFromNullable(impl.tagCount())
      .map(value => zio.aws.s3.model.primitives.TagCount(value))
    override val versionId: Optional[ObjectVersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
    override val bucketKeyEnabled: Optional[BucketKeyEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bucketKeyEnabled())
        .map(value => zio.aws.s3.model.primitives.BucketKeyEnabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.WriteGetObjectResponseRequest
  ): zio.aws.s3.model.WriteGetObjectResponseRequest.ReadOnly = new Wrapper(impl)
}
