package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AccelerateConfiguration(
    status: Option[zio.aws.s3.model.BucketAccelerateStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.AccelerateConfiguration = {
    import AccelerateConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.AccelerateConfiguration
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.AccelerateConfiguration.ReadOnly =
    zio.aws.s3.model.AccelerateConfiguration.wrap(buildAwsValue())
}
object AccelerateConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.AccelerateConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.AccelerateConfiguration =
      zio.aws.s3.model.AccelerateConfiguration(status.map(value => value))
    def status: Option[zio.aws.s3.model.BucketAccelerateStatus]
    def getStatus: ZIO[Any, AwsError, zio.aws.s3.model.BucketAccelerateStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.AccelerateConfiguration
  ) extends zio.aws.s3.model.AccelerateConfiguration.ReadOnly {
    override val status: Option[zio.aws.s3.model.BucketAccelerateStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.s3.model.BucketAccelerateStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.AccelerateConfiguration
  ): zio.aws.s3.model.AccelerateConfiguration.ReadOnly = new Wrapper(impl)
}
