package zio.aws.s3.model
import zio.aws.s3.model.primitives.{Prefix, BucketName, AccountId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AnalyticsS3BucketDestination(
    format: zio.aws.s3.model.AnalyticsS3ExportFileFormat,
    bucketAccountId: Option[AccountId] = None,
    bucket: BucketName,
    prefix: Option[Prefix] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.AnalyticsS3BucketDestination = {
    import AnalyticsS3BucketDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.AnalyticsS3BucketDestination
      .builder()
      .format(format.unwrap)
      .optionallyWith(
        bucketAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.bucketAccountId)
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.AnalyticsS3BucketDestination.ReadOnly =
    zio.aws.s3.model.AnalyticsS3BucketDestination.wrap(buildAwsValue())
}
object AnalyticsS3BucketDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.AnalyticsS3BucketDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.AnalyticsS3BucketDestination =
      zio.aws.s3.model.AnalyticsS3BucketDestination(
        format,
        bucketAccountId.map(value => value),
        bucket,
        prefix.map(value => value)
      )
    def format: zio.aws.s3.model.AnalyticsS3ExportFileFormat
    def bucketAccountId: Option[AccountId]
    def bucket: BucketName
    def prefix: Option[Prefix]
    def getFormat
        : ZIO[Any, Nothing, zio.aws.s3.model.AnalyticsS3ExportFileFormat] =
      ZIO.succeed(format)
    def getBucketAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("bucketAccountId", bucketAccountId)
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.AnalyticsS3BucketDestination
  ) extends zio.aws.s3.model.AnalyticsS3BucketDestination.ReadOnly {
    override val format: zio.aws.s3.model.AnalyticsS3ExportFileFormat =
      zio.aws.s3.model.AnalyticsS3ExportFileFormat.wrap(impl.format())
    override val bucketAccountId: Option[AccountId] = scala
      .Option(impl.bucketAccountId())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val prefix: Option[Prefix] = scala
      .Option(impl.prefix())
      .map(value => zio.aws.s3.model.primitives.Prefix(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.AnalyticsS3BucketDestination
  ): zio.aws.s3.model.AnalyticsS3BucketDestination.ReadOnly = new Wrapper(impl)
}
