package zio.aws.s3.model
import zio.aws.s3.model.primitives.{CreationDate, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Bucket(
    name: Option[BucketName] = None,
    creationDate: Option[CreationDate] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Bucket = {
    import Bucket.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Bucket
      .builder()
      .optionallyWith(
        name.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        creationDate.map(value => CreationDate.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.Bucket.ReadOnly =
    zio.aws.s3.model.Bucket.wrap(buildAwsValue())
}
object Bucket {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Bucket] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.Bucket = zio.aws.s3.model
      .Bucket(name.map(value => value), creationDate.map(value => value))
    def name: Option[BucketName]
    def creationDate: Option[CreationDate]
    def getName: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("name", name)
    def getCreationDate: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.Bucket
  ) extends zio.aws.s3.model.Bucket.ReadOnly {
    override val name: Option[BucketName] = scala
      .Option(impl.name())
      .map(value => zio.aws.s3.model.primitives.BucketName(value))
    override val creationDate: Option[CreationDate] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.s3.model.primitives.CreationDate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Bucket
  ): zio.aws.s3.model.Bucket.ReadOnly = new Wrapper(impl)
}
