package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  QuoteCharacter,
  FieldDelimiter,
  RecordDelimiter,
  QuoteEscapeCharacter
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CSVOutput(
    quoteFields: Option[zio.aws.s3.model.QuoteFields] = None,
    quoteEscapeCharacter: Option[QuoteEscapeCharacter] = None,
    recordDelimiter: Option[RecordDelimiter] = None,
    fieldDelimiter: Option[FieldDelimiter] = None,
    quoteCharacter: Option[QuoteCharacter] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.CSVOutput = {
    import CSVOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CSVOutput
      .builder()
      .optionallyWith(quoteFields.map(value => value.unwrap))(_.quoteFields)
      .optionallyWith(
        quoteEscapeCharacter.map(value =>
          QuoteEscapeCharacter.unwrap(value): java.lang.String
        )
      )(_.quoteEscapeCharacter)
      .optionallyWith(
        recordDelimiter.map(value =>
          RecordDelimiter.unwrap(value): java.lang.String
        )
      )(_.recordDelimiter)
      .optionallyWith(
        fieldDelimiter.map(value =>
          FieldDelimiter.unwrap(value): java.lang.String
        )
      )(_.fieldDelimiter)
      .optionallyWith(
        quoteCharacter.map(value =>
          QuoteCharacter.unwrap(value): java.lang.String
        )
      )(_.quoteCharacter)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.CSVOutput.ReadOnly =
    zio.aws.s3.model.CSVOutput.wrap(buildAwsValue())
}
object CSVOutput {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.CSVOutput] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.CSVOutput = zio.aws.s3.model.CSVOutput(
      quoteFields.map(value => value),
      quoteEscapeCharacter.map(value => value),
      recordDelimiter.map(value => value),
      fieldDelimiter.map(value => value),
      quoteCharacter.map(value => value)
    )
    def quoteFields: Option[zio.aws.s3.model.QuoteFields]
    def quoteEscapeCharacter: Option[QuoteEscapeCharacter]
    def recordDelimiter: Option[RecordDelimiter]
    def fieldDelimiter: Option[FieldDelimiter]
    def quoteCharacter: Option[QuoteCharacter]
    def getQuoteFields: ZIO[Any, AwsError, zio.aws.s3.model.QuoteFields] =
      AwsError.unwrapOptionField("quoteFields", quoteFields)
    def getQuoteEscapeCharacter: ZIO[Any, AwsError, QuoteEscapeCharacter] =
      AwsError.unwrapOptionField("quoteEscapeCharacter", quoteEscapeCharacter)
    def getRecordDelimiter: ZIO[Any, AwsError, RecordDelimiter] =
      AwsError.unwrapOptionField("recordDelimiter", recordDelimiter)
    def getFieldDelimiter: ZIO[Any, AwsError, FieldDelimiter] =
      AwsError.unwrapOptionField("fieldDelimiter", fieldDelimiter)
    def getQuoteCharacter: ZIO[Any, AwsError, QuoteCharacter] =
      AwsError.unwrapOptionField("quoteCharacter", quoteCharacter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CSVOutput
  ) extends zio.aws.s3.model.CSVOutput.ReadOnly {
    override val quoteFields: Option[zio.aws.s3.model.QuoteFields] = scala
      .Option(impl.quoteFields())
      .map(value => zio.aws.s3.model.QuoteFields.wrap(value))
    override val quoteEscapeCharacter: Option[QuoteEscapeCharacter] = scala
      .Option(impl.quoteEscapeCharacter())
      .map(value => zio.aws.s3.model.primitives.QuoteEscapeCharacter(value))
    override val recordDelimiter: Option[RecordDelimiter] = scala
      .Option(impl.recordDelimiter())
      .map(value => zio.aws.s3.model.primitives.RecordDelimiter(value))
    override val fieldDelimiter: Option[FieldDelimiter] = scala
      .Option(impl.fieldDelimiter())
      .map(value => zio.aws.s3.model.primitives.FieldDelimiter(value))
    override val quoteCharacter: Option[QuoteCharacter] = scala
      .Option(impl.quoteCharacter())
      .map(value => zio.aws.s3.model.primitives.QuoteCharacter(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CSVOutput
  ): zio.aws.s3.model.CSVOutput.ReadOnly = new Wrapper(impl)
}
