package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  ETag,
  Expiration,
  ObjectKey,
  BucketName,
  SSEKMSKeyId,
  ObjectVersionId,
  BucketKeyEnabled,
  Location
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CompleteMultipartUploadResponse(
    location: Option[Location] = None,
    bucket: Option[BucketName] = None,
    key: Option[ObjectKey] = None,
    expiration: Option[Expiration] = None,
    eTag: Option[ETag] = None,
    serverSideEncryption: Option[zio.aws.s3.model.ServerSideEncryption] = None,
    versionId: Option[ObjectVersionId] = None,
    ssekmsKeyId: Option[SSEKMSKeyId] = None,
    bucketKeyEnabled: Option[BucketKeyEnabled] = None,
    requestCharged: Option[zio.aws.s3.model.RequestCharged] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse = {
    import CompleteMultipartUploadResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse
      .builder()
      .optionallyWith(
        location.map(value => Location.unwrap(value): java.lang.String)
      )(_.location)
      .optionallyWith(
        bucket.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(
        key.map(value => ObjectKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        expiration.map(value => Expiration.unwrap(value): java.lang.String)
      )(_.expiration)
      .optionallyWith(eTag.map(value => ETag.unwrap(value): java.lang.String))(
        _.eTag
      )
      .optionallyWith(serverSideEncryption.map(value => value.unwrap))(
        _.serverSideEncryption
      )
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(
        ssekmsKeyId.map(value => SSEKMSKeyId.unwrap(value): java.lang.String)
      )(_.ssekmsKeyId)
      .optionallyWith(
        bucketKeyEnabled.map(value =>
          BucketKeyEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.bucketKeyEnabled)
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.CompleteMultipartUploadResponse.ReadOnly =
    zio.aws.s3.model.CompleteMultipartUploadResponse.wrap(buildAwsValue())
}
object CompleteMultipartUploadResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.CompleteMultipartUploadResponse =
      zio.aws.s3.model.CompleteMultipartUploadResponse(
        location.map(value => value),
        bucket.map(value => value),
        key.map(value => value),
        expiration.map(value => value),
        eTag.map(value => value),
        serverSideEncryption.map(value => value),
        versionId.map(value => value),
        ssekmsKeyId.map(value => value),
        bucketKeyEnabled.map(value => value),
        requestCharged.map(value => value)
      )
    def location: Option[Location]
    def bucket: Option[BucketName]
    def key: Option[ObjectKey]
    def expiration: Option[Expiration]
    def eTag: Option[ETag]
    def serverSideEncryption: Option[zio.aws.s3.model.ServerSideEncryption]
    def versionId: Option[ObjectVersionId]
    def ssekmsKeyId: Option[SSEKMSKeyId]
    def bucketKeyEnabled: Option[BucketKeyEnabled]
    def requestCharged: Option[zio.aws.s3.model.RequestCharged]
    def getLocation: ZIO[Any, AwsError, Location] =
      AwsError.unwrapOptionField("location", location)
    def getBucket: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getKey: ZIO[Any, AwsError, ObjectKey] =
      AwsError.unwrapOptionField("key", key)
    def getExpiration: ZIO[Any, AwsError, Expiration] =
      AwsError.unwrapOptionField("expiration", expiration)
    def getETag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getServerSideEncryption
        : ZIO[Any, AwsError, zio.aws.s3.model.ServerSideEncryption] =
      AwsError.unwrapOptionField("serverSideEncryption", serverSideEncryption)
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getSsekmsKeyId: ZIO[Any, AwsError, SSEKMSKeyId] =
      AwsError.unwrapOptionField("ssekmsKeyId", ssekmsKeyId)
    def getBucketKeyEnabled: ZIO[Any, AwsError, BucketKeyEnabled] =
      AwsError.unwrapOptionField("bucketKeyEnabled", bucketKeyEnabled)
    def getRequestCharged: ZIO[Any, AwsError, zio.aws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestCharged)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse
  ) extends zio.aws.s3.model.CompleteMultipartUploadResponse.ReadOnly {
    override val location: Option[Location] = scala
      .Option(impl.location())
      .map(value => zio.aws.s3.model.primitives.Location(value))
    override val bucket: Option[BucketName] = scala
      .Option(impl.bucket())
      .map(value => zio.aws.s3.model.primitives.BucketName(value))
    override val key: Option[ObjectKey] = scala
      .Option(impl.key())
      .map(value => zio.aws.s3.model.primitives.ObjectKey(value))
    override val expiration: Option[Expiration] = scala
      .Option(impl.expiration())
      .map(value => zio.aws.s3.model.primitives.Expiration(value))
    override val eTag: Option[ETag] = scala
      .Option(impl.eTag())
      .map(value => zio.aws.s3.model.primitives.ETag(value))
    override val serverSideEncryption
        : Option[zio.aws.s3.model.ServerSideEncryption] = scala
      .Option(impl.serverSideEncryption())
      .map(value => zio.aws.s3.model.ServerSideEncryption.wrap(value))
    override val versionId: Option[ObjectVersionId] = scala
      .Option(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
    override val ssekmsKeyId: Option[SSEKMSKeyId] = scala
      .Option(impl.ssekmsKeyId())
      .map(value => zio.aws.s3.model.primitives.SSEKMSKeyId(value))
    override val bucketKeyEnabled: Option[BucketKeyEnabled] = scala
      .Option(impl.bucketKeyEnabled())
      .map(value => zio.aws.s3.model.primitives.BucketKeyEnabled(value))
    override val requestCharged: Option[zio.aws.s3.model.RequestCharged] = scala
      .Option(impl.requestCharged())
      .map(value => zio.aws.s3.model.RequestCharged.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse
  ): zio.aws.s3.model.CompleteMultipartUploadResponse.ReadOnly = new Wrapper(
    impl
  )
}
