package zio.aws.s3.model
import java.lang.Integer
import zio.aws.s3.model.primitives.{PartNumber, ETag}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CompletedPart(
    eTag: Option[ETag] = None,
    partNumber: Option[PartNumber] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.CompletedPart = {
    import CompletedPart.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CompletedPart
      .builder()
      .optionallyWith(eTag.map(value => ETag.unwrap(value): java.lang.String))(
        _.eTag
      )
      .optionallyWith(
        partNumber.map(value => PartNumber.unwrap(value): Integer)
      )(_.partNumber)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.CompletedPart.ReadOnly =
    zio.aws.s3.model.CompletedPart.wrap(buildAwsValue())
}
object CompletedPart {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.CompletedPart] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.CompletedPart = zio.aws.s3.model
      .CompletedPart(eTag.map(value => value), partNumber.map(value => value))
    def eTag: Option[ETag]
    def partNumber: Option[PartNumber]
    def getETag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getPartNumber: ZIO[Any, AwsError, PartNumber] =
      AwsError.unwrapOptionField("partNumber", partNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CompletedPart
  ) extends zio.aws.s3.model.CompletedPart.ReadOnly {
    override val eTag: Option[ETag] = scala
      .Option(impl.eTag())
      .map(value => zio.aws.s3.model.primitives.ETag(value))
    override val partNumber: Option[PartNumber] = scala
      .Option(impl.partNumber())
      .map(value => zio.aws.s3.model.primitives.PartNumber(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CompletedPart
  ): zio.aws.s3.model.CompletedPart.ReadOnly = new Wrapper(impl)
}
