package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  SSECustomerKey,
  CopySourceSSECustomerKeyMD5,
  CopySourceSSECustomerAlgorithm,
  ContentType,
  CacheControl,
  WebsiteRedirectLocation,
  GrantRead,
  ContentDisposition,
  ContentLanguage,
  GrantReadACP,
  AccountId,
  SSECustomerAlgorithm,
  CopySourceIfUnmodifiedSince,
  SSECustomerKeyMD5,
  SSEKMSEncryptionContext,
  CopySourceIfMatch,
  Expires,
  ContentEncoding,
  ObjectKey,
  GrantWriteACP,
  GrantFullControl,
  BucketName,
  SSEKMSKeyId,
  CopySourceSSECustomerKey,
  MetadataValue,
  TaggingHeader,
  CopySourceIfNoneMatch,
  ObjectLockRetainUntilDate,
  CopySourceIfModifiedSince,
  MetadataKey,
  CopySource,
  BucketKeyEnabled
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CopyObjectRequest(
    acl: Option[zio.aws.s3.model.ObjectCannedACL] = None,
    destinationBucket: BucketName,
    cacheControl: Option[CacheControl] = None,
    contentDisposition: Option[ContentDisposition] = None,
    contentEncoding: Option[ContentEncoding] = None,
    contentLanguage: Option[ContentLanguage] = None,
    contentType: Option[ContentType] = None,
    copySource: CopySource,
    copySourceIfMatch: Option[CopySourceIfMatch] = None,
    copySourceIfModifiedSince: Option[CopySourceIfModifiedSince] = None,
    copySourceIfNoneMatch: Option[CopySourceIfNoneMatch] = None,
    copySourceIfUnmodifiedSince: Option[CopySourceIfUnmodifiedSince] = None,
    expires: Option[Expires] = None,
    grantFullControl: Option[GrantFullControl] = None,
    grantRead: Option[GrantRead] = None,
    grantReadACP: Option[GrantReadACP] = None,
    grantWriteACP: Option[GrantWriteACP] = None,
    destinationKey: ObjectKey,
    metadata: Option[Map[MetadataKey, MetadataValue]] = None,
    metadataDirective: Option[zio.aws.s3.model.MetadataDirective] = None,
    taggingDirective: Option[zio.aws.s3.model.TaggingDirective] = None,
    serverSideEncryption: Option[zio.aws.s3.model.ServerSideEncryption] = None,
    storageClass: Option[zio.aws.s3.model.StorageClass] = None,
    websiteRedirectLocation: Option[WebsiteRedirectLocation] = None,
    sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = None,
    sseCustomerKey: Option[SSECustomerKey] = None,
    sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = None,
    ssekmsKeyId: Option[SSEKMSKeyId] = None,
    ssekmsEncryptionContext: Option[SSEKMSEncryptionContext] = None,
    bucketKeyEnabled: Option[BucketKeyEnabled] = None,
    copySourceSSECustomerAlgorithm: Option[CopySourceSSECustomerAlgorithm] =
      None,
    copySourceSSECustomerKey: Option[CopySourceSSECustomerKey] = None,
    copySourceSSECustomerKeyMD5: Option[CopySourceSSECustomerKeyMD5] = None,
    requestPayer: Option[zio.aws.s3.model.RequestPayer] = None,
    tagging: Option[TaggingHeader] = None,
    objectLockMode: Option[zio.aws.s3.model.ObjectLockMode] = None,
    objectLockRetainUntilDate: Option[ObjectLockRetainUntilDate] = None,
    objectLockLegalHoldStatus: Option[
      zio.aws.s3.model.ObjectLockLegalHoldStatus
    ] = None,
    expectedBucketOwner: Option[AccountId] = None,
    expectedSourceBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.CopyObjectRequest = {
    import CopyObjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CopyObjectRequest
      .builder()
      .optionallyWith(acl.map(value => value.unwrap))(_.acl)
      .destinationBucket(BucketName.unwrap(destinationBucket): java.lang.String)
      .optionallyWith(
        cacheControl.map(value => CacheControl.unwrap(value): java.lang.String)
      )(_.cacheControl)
      .optionallyWith(
        contentDisposition.map(value =>
          ContentDisposition.unwrap(value): java.lang.String
        )
      )(_.contentDisposition)
      .optionallyWith(
        contentEncoding.map(value =>
          ContentEncoding.unwrap(value): java.lang.String
        )
      )(_.contentEncoding)
      .optionallyWith(
        contentLanguage.map(value =>
          ContentLanguage.unwrap(value): java.lang.String
        )
      )(_.contentLanguage)
      .optionallyWith(
        contentType.map(value => ContentType.unwrap(value): java.lang.String)
      )(_.contentType)
      .copySource(CopySource.unwrap(copySource): java.lang.String)
      .optionallyWith(
        copySourceIfMatch.map(value =>
          CopySourceIfMatch.unwrap(value): java.lang.String
        )
      )(_.copySourceIfMatch)
      .optionallyWith(
        copySourceIfModifiedSince.map(value =>
          CopySourceIfModifiedSince.unwrap(value): Instant
        )
      )(_.copySourceIfModifiedSince)
      .optionallyWith(
        copySourceIfNoneMatch.map(value =>
          CopySourceIfNoneMatch.unwrap(value): java.lang.String
        )
      )(_.copySourceIfNoneMatch)
      .optionallyWith(
        copySourceIfUnmodifiedSince.map(value =>
          CopySourceIfUnmodifiedSince.unwrap(value): Instant
        )
      )(_.copySourceIfUnmodifiedSince)
      .optionallyWith(expires.map(value => Expires.unwrap(value): Instant))(
        _.expires
      )
      .optionallyWith(
        grantFullControl.map(value =>
          GrantFullControl.unwrap(value): java.lang.String
        )
      )(_.grantFullControl)
      .optionallyWith(
        grantRead.map(value => GrantRead.unwrap(value): java.lang.String)
      )(_.grantRead)
      .optionallyWith(
        grantReadACP.map(value => GrantReadACP.unwrap(value): java.lang.String)
      )(_.grantReadACP)
      .optionallyWith(
        grantWriteACP.map(value =>
          GrantWriteACP.unwrap(value): java.lang.String
        )
      )(_.grantWriteACP)
      .destinationKey(ObjectKey.unwrap(destinationKey): java.lang.String)
      .optionallyWith(
        metadata.map(value =>
          value
            .map({ case (key, value) =>
              (MetadataKey.unwrap(key): java.lang.String) -> (MetadataValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.metadata)
      .optionallyWith(metadataDirective.map(value => value.unwrap))(
        _.metadataDirective
      )
      .optionallyWith(taggingDirective.map(value => value.unwrap))(
        _.taggingDirective
      )
      .optionallyWith(serverSideEncryption.map(value => value.unwrap))(
        _.serverSideEncryption
      )
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(
        websiteRedirectLocation.map(value =>
          WebsiteRedirectLocation.unwrap(value): java.lang.String
        )
      )(_.websiteRedirectLocation)
      .optionallyWith(
        sseCustomerAlgorithm.map(value =>
          SSECustomerAlgorithm.unwrap(value): java.lang.String
        )
      )(_.sseCustomerAlgorithm)
      .optionallyWith(
        sseCustomerKey.map(value =>
          SSECustomerKey.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKey)
      .optionallyWith(
        sseCustomerKeyMD5.map(value =>
          SSECustomerKeyMD5.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKeyMD5)
      .optionallyWith(
        ssekmsKeyId.map(value => SSEKMSKeyId.unwrap(value): java.lang.String)
      )(_.ssekmsKeyId)
      .optionallyWith(
        ssekmsEncryptionContext.map(value =>
          SSEKMSEncryptionContext.unwrap(value): java.lang.String
        )
      )(_.ssekmsEncryptionContext)
      .optionallyWith(
        bucketKeyEnabled.map(value =>
          BucketKeyEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.bucketKeyEnabled)
      .optionallyWith(
        copySourceSSECustomerAlgorithm.map(value =>
          CopySourceSSECustomerAlgorithm.unwrap(value): java.lang.String
        )
      )(_.copySourceSSECustomerAlgorithm)
      .optionallyWith(
        copySourceSSECustomerKey.map(value =>
          CopySourceSSECustomerKey.unwrap(value): java.lang.String
        )
      )(_.copySourceSSECustomerKey)
      .optionallyWith(
        copySourceSSECustomerKeyMD5.map(value =>
          CopySourceSSECustomerKeyMD5.unwrap(value): java.lang.String
        )
      )(_.copySourceSSECustomerKeyMD5)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        tagging.map(value => TaggingHeader.unwrap(value): java.lang.String)
      )(_.tagging)
      .optionallyWith(objectLockMode.map(value => value.unwrap))(
        _.objectLockMode
      )
      .optionallyWith(
        objectLockRetainUntilDate.map(value =>
          ObjectLockRetainUntilDate.unwrap(value): Instant
        )
      )(_.objectLockRetainUntilDate)
      .optionallyWith(objectLockLegalHoldStatus.map(value => value.unwrap))(
        _.objectLockLegalHoldStatus
      )
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .optionallyWith(
        expectedSourceBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedSourceBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.CopyObjectRequest.ReadOnly =
    zio.aws.s3.model.CopyObjectRequest.wrap(buildAwsValue())
}
object CopyObjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.CopyObjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.CopyObjectRequest =
      zio.aws.s3.model.CopyObjectRequest(
        acl.map(value => value),
        destinationBucket,
        cacheControl.map(value => value),
        contentDisposition.map(value => value),
        contentEncoding.map(value => value),
        contentLanguage.map(value => value),
        contentType.map(value => value),
        copySource,
        copySourceIfMatch.map(value => value),
        copySourceIfModifiedSince.map(value => value),
        copySourceIfNoneMatch.map(value => value),
        copySourceIfUnmodifiedSince.map(value => value),
        expires.map(value => value),
        grantFullControl.map(value => value),
        grantRead.map(value => value),
        grantReadACP.map(value => value),
        grantWriteACP.map(value => value),
        destinationKey,
        metadata.map(value => value),
        metadataDirective.map(value => value),
        taggingDirective.map(value => value),
        serverSideEncryption.map(value => value),
        storageClass.map(value => value),
        websiteRedirectLocation.map(value => value),
        sseCustomerAlgorithm.map(value => value),
        sseCustomerKey.map(value => value),
        sseCustomerKeyMD5.map(value => value),
        ssekmsKeyId.map(value => value),
        ssekmsEncryptionContext.map(value => value),
        bucketKeyEnabled.map(value => value),
        copySourceSSECustomerAlgorithm.map(value => value),
        copySourceSSECustomerKey.map(value => value),
        copySourceSSECustomerKeyMD5.map(value => value),
        requestPayer.map(value => value),
        tagging.map(value => value),
        objectLockMode.map(value => value),
        objectLockRetainUntilDate.map(value => value),
        objectLockLegalHoldStatus.map(value => value),
        expectedBucketOwner.map(value => value),
        expectedSourceBucketOwner.map(value => value)
      )
    def acl: Option[zio.aws.s3.model.ObjectCannedACL]
    def destinationBucket: BucketName
    def cacheControl: Option[CacheControl]
    def contentDisposition: Option[ContentDisposition]
    def contentEncoding: Option[ContentEncoding]
    def contentLanguage: Option[ContentLanguage]
    def contentType: Option[ContentType]
    def copySource: CopySource
    def copySourceIfMatch: Option[CopySourceIfMatch]
    def copySourceIfModifiedSince: Option[CopySourceIfModifiedSince]
    def copySourceIfNoneMatch: Option[CopySourceIfNoneMatch]
    def copySourceIfUnmodifiedSince: Option[CopySourceIfUnmodifiedSince]
    def expires: Option[Expires]
    def grantFullControl: Option[GrantFullControl]
    def grantRead: Option[GrantRead]
    def grantReadACP: Option[GrantReadACP]
    def grantWriteACP: Option[GrantWriteACP]
    def destinationKey: ObjectKey
    def metadata: Option[Map[MetadataKey, MetadataValue]]
    def metadataDirective: Option[zio.aws.s3.model.MetadataDirective]
    def taggingDirective: Option[zio.aws.s3.model.TaggingDirective]
    def serverSideEncryption: Option[zio.aws.s3.model.ServerSideEncryption]
    def storageClass: Option[zio.aws.s3.model.StorageClass]
    def websiteRedirectLocation: Option[WebsiteRedirectLocation]
    def sseCustomerAlgorithm: Option[SSECustomerAlgorithm]
    def sseCustomerKey: Option[SSECustomerKey]
    def sseCustomerKeyMD5: Option[SSECustomerKeyMD5]
    def ssekmsKeyId: Option[SSEKMSKeyId]
    def ssekmsEncryptionContext: Option[SSEKMSEncryptionContext]
    def bucketKeyEnabled: Option[BucketKeyEnabled]
    def copySourceSSECustomerAlgorithm: Option[CopySourceSSECustomerAlgorithm]
    def copySourceSSECustomerKey: Option[CopySourceSSECustomerKey]
    def copySourceSSECustomerKeyMD5: Option[CopySourceSSECustomerKeyMD5]
    def requestPayer: Option[zio.aws.s3.model.RequestPayer]
    def tagging: Option[TaggingHeader]
    def objectLockMode: Option[zio.aws.s3.model.ObjectLockMode]
    def objectLockRetainUntilDate: Option[ObjectLockRetainUntilDate]
    def objectLockLegalHoldStatus
        : Option[zio.aws.s3.model.ObjectLockLegalHoldStatus]
    def expectedBucketOwner: Option[AccountId]
    def expectedSourceBucketOwner: Option[AccountId]
    def getAcl: ZIO[Any, AwsError, zio.aws.s3.model.ObjectCannedACL] =
      AwsError.unwrapOptionField("acl", acl)
    def getDestinationBucket: ZIO[Any, Nothing, BucketName] =
      ZIO.succeed(destinationBucket)
    def getCacheControl: ZIO[Any, AwsError, CacheControl] =
      AwsError.unwrapOptionField("cacheControl", cacheControl)
    def getContentDisposition: ZIO[Any, AwsError, ContentDisposition] =
      AwsError.unwrapOptionField("contentDisposition", contentDisposition)
    def getContentEncoding: ZIO[Any, AwsError, ContentEncoding] =
      AwsError.unwrapOptionField("contentEncoding", contentEncoding)
    def getContentLanguage: ZIO[Any, AwsError, ContentLanguage] =
      AwsError.unwrapOptionField("contentLanguage", contentLanguage)
    def getContentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getCopySource: ZIO[Any, Nothing, CopySource] = ZIO.succeed(copySource)
    def getCopySourceIfMatch: ZIO[Any, AwsError, CopySourceIfMatch] =
      AwsError.unwrapOptionField("copySourceIfMatch", copySourceIfMatch)
    def getCopySourceIfModifiedSince
        : ZIO[Any, AwsError, CopySourceIfModifiedSince] = AwsError
      .unwrapOptionField("copySourceIfModifiedSince", copySourceIfModifiedSince)
    def getCopySourceIfNoneMatch: ZIO[Any, AwsError, CopySourceIfNoneMatch] =
      AwsError.unwrapOptionField("copySourceIfNoneMatch", copySourceIfNoneMatch)
    def getCopySourceIfUnmodifiedSince
        : ZIO[Any, AwsError, CopySourceIfUnmodifiedSince] =
      AwsError.unwrapOptionField(
        "copySourceIfUnmodifiedSince",
        copySourceIfUnmodifiedSince
      )
    def getExpires: ZIO[Any, AwsError, Expires] =
      AwsError.unwrapOptionField("expires", expires)
    def getGrantFullControl: ZIO[Any, AwsError, GrantFullControl] =
      AwsError.unwrapOptionField("grantFullControl", grantFullControl)
    def getGrantRead: ZIO[Any, AwsError, GrantRead] =
      AwsError.unwrapOptionField("grantRead", grantRead)
    def getGrantReadACP: ZIO[Any, AwsError, GrantReadACP] =
      AwsError.unwrapOptionField("grantReadACP", grantReadACP)
    def getGrantWriteACP: ZIO[Any, AwsError, GrantWriteACP] =
      AwsError.unwrapOptionField("grantWriteACP", grantWriteACP)
    def getDestinationKey: ZIO[Any, Nothing, ObjectKey] =
      ZIO.succeed(destinationKey)
    def getMetadata: ZIO[Any, AwsError, Map[MetadataKey, MetadataValue]] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getMetadataDirective
        : ZIO[Any, AwsError, zio.aws.s3.model.MetadataDirective] =
      AwsError.unwrapOptionField("metadataDirective", metadataDirective)
    def getTaggingDirective
        : ZIO[Any, AwsError, zio.aws.s3.model.TaggingDirective] =
      AwsError.unwrapOptionField("taggingDirective", taggingDirective)
    def getServerSideEncryption
        : ZIO[Any, AwsError, zio.aws.s3.model.ServerSideEncryption] =
      AwsError.unwrapOptionField("serverSideEncryption", serverSideEncryption)
    def getStorageClass: ZIO[Any, AwsError, zio.aws.s3.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getWebsiteRedirectLocation
        : ZIO[Any, AwsError, WebsiteRedirectLocation] = AwsError
      .unwrapOptionField("websiteRedirectLocation", websiteRedirectLocation)
    def getSseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField("sseCustomerAlgorithm", sseCustomerAlgorithm)
    def getSseCustomerKey: ZIO[Any, AwsError, SSECustomerKey] =
      AwsError.unwrapOptionField("sseCustomerKey", sseCustomerKey)
    def getSseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5)
    def getSsekmsKeyId: ZIO[Any, AwsError, SSEKMSKeyId] =
      AwsError.unwrapOptionField("ssekmsKeyId", ssekmsKeyId)
    def getSsekmsEncryptionContext
        : ZIO[Any, AwsError, SSEKMSEncryptionContext] = AwsError
      .unwrapOptionField("ssekmsEncryptionContext", ssekmsEncryptionContext)
    def getBucketKeyEnabled: ZIO[Any, AwsError, BucketKeyEnabled] =
      AwsError.unwrapOptionField("bucketKeyEnabled", bucketKeyEnabled)
    def getCopySourceSSECustomerAlgorithm
        : ZIO[Any, AwsError, CopySourceSSECustomerAlgorithm] =
      AwsError.unwrapOptionField(
        "copySourceSSECustomerAlgorithm",
        copySourceSSECustomerAlgorithm
      )
    def getCopySourceSSECustomerKey
        : ZIO[Any, AwsError, CopySourceSSECustomerKey] = AwsError
      .unwrapOptionField("copySourceSSECustomerKey", copySourceSSECustomerKey)
    def getCopySourceSSECustomerKeyMD5
        : ZIO[Any, AwsError, CopySourceSSECustomerKeyMD5] =
      AwsError.unwrapOptionField(
        "copySourceSSECustomerKeyMD5",
        copySourceSSECustomerKeyMD5
      )
    def getRequestPayer: ZIO[Any, AwsError, zio.aws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayer)
    def getTagging: ZIO[Any, AwsError, TaggingHeader] =
      AwsError.unwrapOptionField("tagging", tagging)
    def getObjectLockMode: ZIO[Any, AwsError, zio.aws.s3.model.ObjectLockMode] =
      AwsError.unwrapOptionField("objectLockMode", objectLockMode)
    def getObjectLockRetainUntilDate
        : ZIO[Any, AwsError, ObjectLockRetainUntilDate] = AwsError
      .unwrapOptionField("objectLockRetainUntilDate", objectLockRetainUntilDate)
    def getObjectLockLegalHoldStatus
        : ZIO[Any, AwsError, zio.aws.s3.model.ObjectLockLegalHoldStatus] =
      AwsError.unwrapOptionField(
        "objectLockLegalHoldStatus",
        objectLockLegalHoldStatus
      )
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
    def getExpectedSourceBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedSourceBucketOwner", expectedSourceBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CopyObjectRequest
  ) extends zio.aws.s3.model.CopyObjectRequest.ReadOnly {
    override val acl: Option[zio.aws.s3.model.ObjectCannedACL] = scala
      .Option(impl.acl())
      .map(value => zio.aws.s3.model.ObjectCannedACL.wrap(value))
    override val destinationBucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.destinationBucket())
    override val cacheControl: Option[CacheControl] = scala
      .Option(impl.cacheControl())
      .map(value => zio.aws.s3.model.primitives.CacheControl(value))
    override val contentDisposition: Option[ContentDisposition] = scala
      .Option(impl.contentDisposition())
      .map(value => zio.aws.s3.model.primitives.ContentDisposition(value))
    override val contentEncoding: Option[ContentEncoding] = scala
      .Option(impl.contentEncoding())
      .map(value => zio.aws.s3.model.primitives.ContentEncoding(value))
    override val contentLanguage: Option[ContentLanguage] = scala
      .Option(impl.contentLanguage())
      .map(value => zio.aws.s3.model.primitives.ContentLanguage(value))
    override val contentType: Option[ContentType] = scala
      .Option(impl.contentType())
      .map(value => zio.aws.s3.model.primitives.ContentType(value))
    override val copySource: CopySource =
      zio.aws.s3.model.primitives.CopySource(impl.copySource())
    override val copySourceIfMatch: Option[CopySourceIfMatch] = scala
      .Option(impl.copySourceIfMatch())
      .map(value => zio.aws.s3.model.primitives.CopySourceIfMatch(value))
    override val copySourceIfModifiedSince: Option[CopySourceIfModifiedSince] =
      scala
        .Option(impl.copySourceIfModifiedSince())
        .map(value =>
          zio.aws.s3.model.primitives.CopySourceIfModifiedSince(value)
        )
    override val copySourceIfNoneMatch: Option[CopySourceIfNoneMatch] = scala
      .Option(impl.copySourceIfNoneMatch())
      .map(value => zio.aws.s3.model.primitives.CopySourceIfNoneMatch(value))
    override val copySourceIfUnmodifiedSince
        : Option[CopySourceIfUnmodifiedSince] = scala
      .Option(impl.copySourceIfUnmodifiedSince())
      .map(value =>
        zio.aws.s3.model.primitives.CopySourceIfUnmodifiedSince(value)
      )
    override val expires: Option[Expires] = scala
      .Option(impl.expires())
      .map(value => zio.aws.s3.model.primitives.Expires(value))
    override val grantFullControl: Option[GrantFullControl] = scala
      .Option(impl.grantFullControl())
      .map(value => zio.aws.s3.model.primitives.GrantFullControl(value))
    override val grantRead: Option[GrantRead] = scala
      .Option(impl.grantRead())
      .map(value => zio.aws.s3.model.primitives.GrantRead(value))
    override val grantReadACP: Option[GrantReadACP] = scala
      .Option(impl.grantReadACP())
      .map(value => zio.aws.s3.model.primitives.GrantReadACP(value))
    override val grantWriteACP: Option[GrantWriteACP] = scala
      .Option(impl.grantWriteACP())
      .map(value => zio.aws.s3.model.primitives.GrantWriteACP(value))
    override val destinationKey: ObjectKey =
      zio.aws.s3.model.primitives.ObjectKey(impl.destinationKey())
    override val metadata: Option[Map[MetadataKey, MetadataValue]] = scala
      .Option(impl.metadata())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.s3.model.primitives.MetadataKey(
              key
            ) -> zio.aws.s3.model.primitives.MetadataValue(value)
          })
          .toMap
      )
    override val metadataDirective: Option[zio.aws.s3.model.MetadataDirective] =
      scala
        .Option(impl.metadataDirective())
        .map(value => zio.aws.s3.model.MetadataDirective.wrap(value))
    override val taggingDirective: Option[zio.aws.s3.model.TaggingDirective] =
      scala
        .Option(impl.taggingDirective())
        .map(value => zio.aws.s3.model.TaggingDirective.wrap(value))
    override val serverSideEncryption
        : Option[zio.aws.s3.model.ServerSideEncryption] = scala
      .Option(impl.serverSideEncryption())
      .map(value => zio.aws.s3.model.ServerSideEncryption.wrap(value))
    override val storageClass: Option[zio.aws.s3.model.StorageClass] = scala
      .Option(impl.storageClass())
      .map(value => zio.aws.s3.model.StorageClass.wrap(value))
    override val websiteRedirectLocation: Option[WebsiteRedirectLocation] =
      scala
        .Option(impl.websiteRedirectLocation())
        .map(value =>
          zio.aws.s3.model.primitives.WebsiteRedirectLocation(value)
        )
    override val sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = scala
      .Option(impl.sseCustomerAlgorithm())
      .map(value => zio.aws.s3.model.primitives.SSECustomerAlgorithm(value))
    override val sseCustomerKey: Option[SSECustomerKey] = scala
      .Option(impl.sseCustomerKey())
      .map(value => zio.aws.s3.model.primitives.SSECustomerKey(value))
    override val sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = scala
      .Option(impl.sseCustomerKeyMD5())
      .map(value => zio.aws.s3.model.primitives.SSECustomerKeyMD5(value))
    override val ssekmsKeyId: Option[SSEKMSKeyId] = scala
      .Option(impl.ssekmsKeyId())
      .map(value => zio.aws.s3.model.primitives.SSEKMSKeyId(value))
    override val ssekmsEncryptionContext: Option[SSEKMSEncryptionContext] =
      scala
        .Option(impl.ssekmsEncryptionContext())
        .map(value =>
          zio.aws.s3.model.primitives.SSEKMSEncryptionContext(value)
        )
    override val bucketKeyEnabled: Option[BucketKeyEnabled] = scala
      .Option(impl.bucketKeyEnabled())
      .map(value => zio.aws.s3.model.primitives.BucketKeyEnabled(value))
    override val copySourceSSECustomerAlgorithm
        : Option[CopySourceSSECustomerAlgorithm] = scala
      .Option(impl.copySourceSSECustomerAlgorithm())
      .map(value =>
        zio.aws.s3.model.primitives.CopySourceSSECustomerAlgorithm(value)
      )
    override val copySourceSSECustomerKey: Option[CopySourceSSECustomerKey] =
      scala
        .Option(impl.copySourceSSECustomerKey())
        .map(value =>
          zio.aws.s3.model.primitives.CopySourceSSECustomerKey(value)
        )
    override val copySourceSSECustomerKeyMD5
        : Option[CopySourceSSECustomerKeyMD5] = scala
      .Option(impl.copySourceSSECustomerKeyMD5())
      .map(value =>
        zio.aws.s3.model.primitives.CopySourceSSECustomerKeyMD5(value)
      )
    override val requestPayer: Option[zio.aws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => zio.aws.s3.model.RequestPayer.wrap(value))
    override val tagging: Option[TaggingHeader] = scala
      .Option(impl.tagging())
      .map(value => zio.aws.s3.model.primitives.TaggingHeader(value))
    override val objectLockMode: Option[zio.aws.s3.model.ObjectLockMode] = scala
      .Option(impl.objectLockMode())
      .map(value => zio.aws.s3.model.ObjectLockMode.wrap(value))
    override val objectLockRetainUntilDate: Option[ObjectLockRetainUntilDate] =
      scala
        .Option(impl.objectLockRetainUntilDate())
        .map(value =>
          zio.aws.s3.model.primitives.ObjectLockRetainUntilDate(value)
        )
    override val objectLockLegalHoldStatus
        : Option[zio.aws.s3.model.ObjectLockLegalHoldStatus] = scala
      .Option(impl.objectLockLegalHoldStatus())
      .map(value => zio.aws.s3.model.ObjectLockLegalHoldStatus.wrap(value))
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
    override val expectedSourceBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedSourceBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CopyObjectRequest
  ): zio.aws.s3.model.CopyObjectRequest.ReadOnly = new Wrapper(impl)
}
