package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  Expiration,
  SSECustomerAlgorithm,
  SSECustomerKeyMD5,
  SSEKMSEncryptionContext,
  SSEKMSKeyId,
  ObjectVersionId,
  CopySourceVersionId,
  BucketKeyEnabled
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CopyObjectResponse(
    copyObjectResult: Option[zio.aws.s3.model.CopyObjectResult] = None,
    expiration: Option[Expiration] = None,
    copySourceVersionId: Option[CopySourceVersionId] = None,
    versionId: Option[ObjectVersionId] = None,
    serverSideEncryption: Option[zio.aws.s3.model.ServerSideEncryption] = None,
    sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = None,
    sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = None,
    ssekmsKeyId: Option[SSEKMSKeyId] = None,
    ssekmsEncryptionContext: Option[SSEKMSEncryptionContext] = None,
    bucketKeyEnabled: Option[BucketKeyEnabled] = None,
    requestCharged: Option[zio.aws.s3.model.RequestCharged] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.CopyObjectResponse = {
    import CopyObjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CopyObjectResponse
      .builder()
      .optionallyWith(copyObjectResult.map(value => value.buildAwsValue()))(
        _.copyObjectResult
      )
      .optionallyWith(
        expiration.map(value => Expiration.unwrap(value): java.lang.String)
      )(_.expiration)
      .optionallyWith(
        copySourceVersionId.map(value =>
          CopySourceVersionId.unwrap(value): java.lang.String
        )
      )(_.copySourceVersionId)
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(serverSideEncryption.map(value => value.unwrap))(
        _.serverSideEncryption
      )
      .optionallyWith(
        sseCustomerAlgorithm.map(value =>
          SSECustomerAlgorithm.unwrap(value): java.lang.String
        )
      )(_.sseCustomerAlgorithm)
      .optionallyWith(
        sseCustomerKeyMD5.map(value =>
          SSECustomerKeyMD5.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKeyMD5)
      .optionallyWith(
        ssekmsKeyId.map(value => SSEKMSKeyId.unwrap(value): java.lang.String)
      )(_.ssekmsKeyId)
      .optionallyWith(
        ssekmsEncryptionContext.map(value =>
          SSEKMSEncryptionContext.unwrap(value): java.lang.String
        )
      )(_.ssekmsEncryptionContext)
      .optionallyWith(
        bucketKeyEnabled.map(value =>
          BucketKeyEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.bucketKeyEnabled)
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.CopyObjectResponse.ReadOnly =
    zio.aws.s3.model.CopyObjectResponse.wrap(buildAwsValue())
}
object CopyObjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.CopyObjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.CopyObjectResponse =
      zio.aws.s3.model.CopyObjectResponse(
        copyObjectResult.map(value => value.asEditable),
        expiration.map(value => value),
        copySourceVersionId.map(value => value),
        versionId.map(value => value),
        serverSideEncryption.map(value => value),
        sseCustomerAlgorithm.map(value => value),
        sseCustomerKeyMD5.map(value => value),
        ssekmsKeyId.map(value => value),
        ssekmsEncryptionContext.map(value => value),
        bucketKeyEnabled.map(value => value),
        requestCharged.map(value => value)
      )
    def copyObjectResult: Option[zio.aws.s3.model.CopyObjectResult.ReadOnly]
    def expiration: Option[Expiration]
    def copySourceVersionId: Option[CopySourceVersionId]
    def versionId: Option[ObjectVersionId]
    def serverSideEncryption: Option[zio.aws.s3.model.ServerSideEncryption]
    def sseCustomerAlgorithm: Option[SSECustomerAlgorithm]
    def sseCustomerKeyMD5: Option[SSECustomerKeyMD5]
    def ssekmsKeyId: Option[SSEKMSKeyId]
    def ssekmsEncryptionContext: Option[SSEKMSEncryptionContext]
    def bucketKeyEnabled: Option[BucketKeyEnabled]
    def requestCharged: Option[zio.aws.s3.model.RequestCharged]
    def getCopyObjectResult
        : ZIO[Any, AwsError, zio.aws.s3.model.CopyObjectResult.ReadOnly] =
      AwsError.unwrapOptionField("copyObjectResult", copyObjectResult)
    def getExpiration: ZIO[Any, AwsError, Expiration] =
      AwsError.unwrapOptionField("expiration", expiration)
    def getCopySourceVersionId: ZIO[Any, AwsError, CopySourceVersionId] =
      AwsError.unwrapOptionField("copySourceVersionId", copySourceVersionId)
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getServerSideEncryption
        : ZIO[Any, AwsError, zio.aws.s3.model.ServerSideEncryption] =
      AwsError.unwrapOptionField("serverSideEncryption", serverSideEncryption)
    def getSseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField("sseCustomerAlgorithm", sseCustomerAlgorithm)
    def getSseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5)
    def getSsekmsKeyId: ZIO[Any, AwsError, SSEKMSKeyId] =
      AwsError.unwrapOptionField("ssekmsKeyId", ssekmsKeyId)
    def getSsekmsEncryptionContext
        : ZIO[Any, AwsError, SSEKMSEncryptionContext] = AwsError
      .unwrapOptionField("ssekmsEncryptionContext", ssekmsEncryptionContext)
    def getBucketKeyEnabled: ZIO[Any, AwsError, BucketKeyEnabled] =
      AwsError.unwrapOptionField("bucketKeyEnabled", bucketKeyEnabled)
    def getRequestCharged: ZIO[Any, AwsError, zio.aws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestCharged)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CopyObjectResponse
  ) extends zio.aws.s3.model.CopyObjectResponse.ReadOnly {
    override val copyObjectResult
        : Option[zio.aws.s3.model.CopyObjectResult.ReadOnly] = scala
      .Option(impl.copyObjectResult())
      .map(value => zio.aws.s3.model.CopyObjectResult.wrap(value))
    override val expiration: Option[Expiration] = scala
      .Option(impl.expiration())
      .map(value => zio.aws.s3.model.primitives.Expiration(value))
    override val copySourceVersionId: Option[CopySourceVersionId] = scala
      .Option(impl.copySourceVersionId())
      .map(value => zio.aws.s3.model.primitives.CopySourceVersionId(value))
    override val versionId: Option[ObjectVersionId] = scala
      .Option(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
    override val serverSideEncryption
        : Option[zio.aws.s3.model.ServerSideEncryption] = scala
      .Option(impl.serverSideEncryption())
      .map(value => zio.aws.s3.model.ServerSideEncryption.wrap(value))
    override val sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = scala
      .Option(impl.sseCustomerAlgorithm())
      .map(value => zio.aws.s3.model.primitives.SSECustomerAlgorithm(value))
    override val sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = scala
      .Option(impl.sseCustomerKeyMD5())
      .map(value => zio.aws.s3.model.primitives.SSECustomerKeyMD5(value))
    override val ssekmsKeyId: Option[SSEKMSKeyId] = scala
      .Option(impl.ssekmsKeyId())
      .map(value => zio.aws.s3.model.primitives.SSEKMSKeyId(value))
    override val ssekmsEncryptionContext: Option[SSEKMSEncryptionContext] =
      scala
        .Option(impl.ssekmsEncryptionContext())
        .map(value =>
          zio.aws.s3.model.primitives.SSEKMSEncryptionContext(value)
        )
    override val bucketKeyEnabled: Option[BucketKeyEnabled] = scala
      .Option(impl.bucketKeyEnabled())
      .map(value => zio.aws.s3.model.primitives.BucketKeyEnabled(value))
    override val requestCharged: Option[zio.aws.s3.model.RequestCharged] = scala
      .Option(impl.requestCharged())
      .map(value => zio.aws.s3.model.RequestCharged.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CopyObjectResponse
  ): zio.aws.s3.model.CopyObjectResponse.ReadOnly = new Wrapper(impl)
}
