package zio.aws.s3.model
import zio.aws.s3.model.primitives.{LastModified, ETag}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CopyObjectResult(
    eTag: Option[ETag] = None,
    lastModified: Option[LastModified] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.CopyObjectResult = {
    import CopyObjectResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CopyObjectResult
      .builder()
      .optionallyWith(eTag.map(value => ETag.unwrap(value): java.lang.String))(
        _.eTag
      )
      .optionallyWith(
        lastModified.map(value => LastModified.unwrap(value): Instant)
      )(_.lastModified)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.CopyObjectResult.ReadOnly =
    zio.aws.s3.model.CopyObjectResult.wrap(buildAwsValue())
}
object CopyObjectResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.CopyObjectResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.CopyObjectResult =
      zio.aws.s3.model.CopyObjectResult(
        eTag.map(value => value),
        lastModified.map(value => value)
      )
    def eTag: Option[ETag]
    def lastModified: Option[LastModified]
    def getETag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getLastModified: ZIO[Any, AwsError, LastModified] =
      AwsError.unwrapOptionField("lastModified", lastModified)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CopyObjectResult
  ) extends zio.aws.s3.model.CopyObjectResult.ReadOnly {
    override val eTag: Option[ETag] = scala
      .Option(impl.eTag())
      .map(value => zio.aws.s3.model.primitives.ETag(value))
    override val lastModified: Option[LastModified] = scala
      .Option(impl.lastModified())
      .map(value => zio.aws.s3.model.primitives.LastModified(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CopyObjectResult
  ): zio.aws.s3.model.CopyObjectResult.ReadOnly = new Wrapper(impl)
}
