package zio.aws.s3.model
import zio.aws.s3.model.primitives.{AccountId, MetricsId, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteBucketMetricsConfigurationRequest(
    bucket: BucketName,
    id: MetricsId,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.DeleteBucketMetricsConfigurationRequest = {
    import DeleteBucketMetricsConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.DeleteBucketMetricsConfigurationRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .id(MetricsId.unwrap(id): java.lang.String)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : zio.aws.s3.model.DeleteBucketMetricsConfigurationRequest.ReadOnly =
    zio.aws.s3.model.DeleteBucketMetricsConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteBucketMetricsConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.DeleteBucketMetricsConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.DeleteBucketMetricsConfigurationRequest =
      zio.aws.s3.model.DeleteBucketMetricsConfigurationRequest(
        bucket,
        id,
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def id: MetricsId
    def expectedBucketOwner: Option[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getId: ZIO[Any, Nothing, MetricsId] = ZIO.succeed(id)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.DeleteBucketMetricsConfigurationRequest
  ) extends zio.aws.s3.model.DeleteBucketMetricsConfigurationRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val id: MetricsId =
      zio.aws.s3.model.primitives.MetricsId(impl.id())
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.DeleteBucketMetricsConfigurationRequest
  ): zio.aws.s3.model.DeleteBucketMetricsConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
