package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  LastModified,
  IsLatest,
  ObjectVersionId,
  ObjectKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DeleteMarkerEntry(
    owner: Option[zio.aws.s3.model.Owner] = None,
    key: Option[ObjectKey] = None,
    versionId: Option[ObjectVersionId] = None,
    isLatest: Option[IsLatest] = None,
    lastModified: Option[LastModified] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.DeleteMarkerEntry = {
    import DeleteMarkerEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.DeleteMarkerEntry
      .builder()
      .optionallyWith(owner.map(value => value.buildAwsValue()))(_.owner)
      .optionallyWith(
        key.map(value => ObjectKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(
        isLatest.map(value => IsLatest.unwrap(value): java.lang.Boolean)
      )(_.isLatest)
      .optionallyWith(
        lastModified.map(value => LastModified.unwrap(value): Instant)
      )(_.lastModified)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.DeleteMarkerEntry.ReadOnly =
    zio.aws.s3.model.DeleteMarkerEntry.wrap(buildAwsValue())
}
object DeleteMarkerEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.DeleteMarkerEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.DeleteMarkerEntry =
      zio.aws.s3.model.DeleteMarkerEntry(
        owner.map(value => value.asEditable),
        key.map(value => value),
        versionId.map(value => value),
        isLatest.map(value => value),
        lastModified.map(value => value)
      )
    def owner: Option[zio.aws.s3.model.Owner.ReadOnly]
    def key: Option[ObjectKey]
    def versionId: Option[ObjectVersionId]
    def isLatest: Option[IsLatest]
    def lastModified: Option[LastModified]
    def getOwner: ZIO[Any, AwsError, zio.aws.s3.model.Owner.ReadOnly] =
      AwsError.unwrapOptionField("owner", owner)
    def getKey: ZIO[Any, AwsError, ObjectKey] =
      AwsError.unwrapOptionField("key", key)
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getIsLatest: ZIO[Any, AwsError, IsLatest] =
      AwsError.unwrapOptionField("isLatest", isLatest)
    def getLastModified: ZIO[Any, AwsError, LastModified] =
      AwsError.unwrapOptionField("lastModified", lastModified)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.DeleteMarkerEntry
  ) extends zio.aws.s3.model.DeleteMarkerEntry.ReadOnly {
    override val owner: Option[zio.aws.s3.model.Owner.ReadOnly] = scala
      .Option(impl.owner())
      .map(value => zio.aws.s3.model.Owner.wrap(value))
    override val key: Option[ObjectKey] = scala
      .Option(impl.key())
      .map(value => zio.aws.s3.model.primitives.ObjectKey(value))
    override val versionId: Option[ObjectVersionId] = scala
      .Option(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
    override val isLatest: Option[IsLatest] = scala
      .Option(impl.isLatest())
      .map(value => zio.aws.s3.model.primitives.IsLatest(value))
    override val lastModified: Option[LastModified] = scala
      .Option(impl.lastModified())
      .map(value => zio.aws.s3.model.primitives.LastModified(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.DeleteMarkerEntry
  ): zio.aws.s3.model.DeleteMarkerEntry.ReadOnly = new Wrapper(impl)
}
