package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteMarkerReplication(
    status: Option[zio.aws.s3.model.DeleteMarkerReplicationStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.DeleteMarkerReplication = {
    import DeleteMarkerReplication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.DeleteMarkerReplication
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.DeleteMarkerReplication.ReadOnly =
    zio.aws.s3.model.DeleteMarkerReplication.wrap(buildAwsValue())
}
object DeleteMarkerReplication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.DeleteMarkerReplication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.DeleteMarkerReplication =
      zio.aws.s3.model.DeleteMarkerReplication(status.map(value => value))
    def status: Option[zio.aws.s3.model.DeleteMarkerReplicationStatus]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.s3.model.DeleteMarkerReplicationStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.DeleteMarkerReplication
  ) extends zio.aws.s3.model.DeleteMarkerReplication.ReadOnly {
    override val status
        : Option[zio.aws.s3.model.DeleteMarkerReplicationStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.s3.model.DeleteMarkerReplicationStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.DeleteMarkerReplication
  ): zio.aws.s3.model.DeleteMarkerReplication.ReadOnly = new Wrapper(impl)
}
