package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  BypassGovernanceRetention,
  MFA,
  AccountId,
  ObjectKey,
  BucketName,
  ObjectVersionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteObjectRequest(
    bucket: BucketName,
    key: ObjectKey,
    mfa: Option[MFA] = None,
    versionId: Option[ObjectVersionId] = None,
    requestPayer: Option[zio.aws.s3.model.RequestPayer] = None,
    bypassGovernanceRetention: Option[BypassGovernanceRetention] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.DeleteObjectRequest = {
    import DeleteObjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.DeleteObjectRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .key(ObjectKey.unwrap(key): java.lang.String)
      .optionallyWith(mfa.map(value => MFA.unwrap(value): java.lang.String))(
        _.mfa
      )
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        bypassGovernanceRetention.map(value =>
          BypassGovernanceRetention.unwrap(value): java.lang.Boolean
        )
      )(_.bypassGovernanceRetention)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.DeleteObjectRequest.ReadOnly =
    zio.aws.s3.model.DeleteObjectRequest.wrap(buildAwsValue())
}
object DeleteObjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.DeleteObjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.DeleteObjectRequest =
      zio.aws.s3.model.DeleteObjectRequest(
        bucket,
        key,
        mfa.map(value => value),
        versionId.map(value => value),
        requestPayer.map(value => value),
        bypassGovernanceRetention.map(value => value),
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def key: ObjectKey
    def mfa: Option[MFA]
    def versionId: Option[ObjectVersionId]
    def requestPayer: Option[zio.aws.s3.model.RequestPayer]
    def bypassGovernanceRetention: Option[BypassGovernanceRetention]
    def expectedBucketOwner: Option[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getKey: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(key)
    def getMfa: ZIO[Any, AwsError, MFA] = AwsError.unwrapOptionField("mfa", mfa)
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getRequestPayer: ZIO[Any, AwsError, zio.aws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayer)
    def getBypassGovernanceRetention
        : ZIO[Any, AwsError, BypassGovernanceRetention] = AwsError
      .unwrapOptionField("bypassGovernanceRetention", bypassGovernanceRetention)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.DeleteObjectRequest
  ) extends zio.aws.s3.model.DeleteObjectRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val key: ObjectKey =
      zio.aws.s3.model.primitives.ObjectKey(impl.key())
    override val mfa: Option[MFA] = scala
      .Option(impl.mfa())
      .map(value => zio.aws.s3.model.primitives.MFA(value))
    override val versionId: Option[ObjectVersionId] = scala
      .Option(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
    override val requestPayer: Option[zio.aws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => zio.aws.s3.model.RequestPayer.wrap(value))
    override val bypassGovernanceRetention: Option[BypassGovernanceRetention] =
      scala
        .Option(impl.bypassGovernanceRetention())
        .map(value =>
          zio.aws.s3.model.primitives.BypassGovernanceRetention(value)
        )
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.DeleteObjectRequest
  ): zio.aws.s3.model.DeleteObjectRequest.ReadOnly = new Wrapper(impl)
}
