package zio.aws.s3.model
import zio.aws.s3.model.primitives.{ObjectVersionId, DeleteMarker}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteObjectResponse(
    deleteMarker: Option[DeleteMarker] = None,
    versionId: Option[ObjectVersionId] = None,
    requestCharged: Option[zio.aws.s3.model.RequestCharged] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.DeleteObjectResponse = {
    import DeleteObjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.DeleteObjectResponse
      .builder()
      .optionallyWith(
        deleteMarker.map(value => DeleteMarker.unwrap(value): java.lang.Boolean)
      )(_.deleteMarker)
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.DeleteObjectResponse.ReadOnly =
    zio.aws.s3.model.DeleteObjectResponse.wrap(buildAwsValue())
}
object DeleteObjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.DeleteObjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.DeleteObjectResponse =
      zio.aws.s3.model.DeleteObjectResponse(
        deleteMarker.map(value => value),
        versionId.map(value => value),
        requestCharged.map(value => value)
      )
    def deleteMarker: Option[DeleteMarker]
    def versionId: Option[ObjectVersionId]
    def requestCharged: Option[zio.aws.s3.model.RequestCharged]
    def getDeleteMarker: ZIO[Any, AwsError, DeleteMarker] =
      AwsError.unwrapOptionField("deleteMarker", deleteMarker)
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getRequestCharged: ZIO[Any, AwsError, zio.aws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestCharged)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.DeleteObjectResponse
  ) extends zio.aws.s3.model.DeleteObjectResponse.ReadOnly {
    override val deleteMarker: Option[DeleteMarker] = scala
      .Option(impl.deleteMarker())
      .map(value => zio.aws.s3.model.primitives.DeleteMarker(value))
    override val versionId: Option[ObjectVersionId] = scala
      .Option(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
    override val requestCharged: Option[zio.aws.s3.model.RequestCharged] = scala
      .Option(impl.requestCharged())
      .map(value => zio.aws.s3.model.RequestCharged.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.DeleteObjectResponse
  ): zio.aws.s3.model.DeleteObjectResponse.ReadOnly = new Wrapper(impl)
}
