package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  AccountId,
  BypassGovernanceRetention,
  MFA,
  BucketName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteObjectsRequest(
    bucket: BucketName,
    delete: zio.aws.s3.model.Delete,
    mfa: Option[MFA] = None,
    requestPayer: Option[zio.aws.s3.model.RequestPayer] = None,
    bypassGovernanceRetention: Option[BypassGovernanceRetention] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.DeleteObjectsRequest = {
    import DeleteObjectsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.DeleteObjectsRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .delete(delete.buildAwsValue())
      .optionallyWith(mfa.map(value => MFA.unwrap(value): java.lang.String))(
        _.mfa
      )
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        bypassGovernanceRetention.map(value =>
          BypassGovernanceRetention.unwrap(value): java.lang.Boolean
        )
      )(_.bypassGovernanceRetention)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.DeleteObjectsRequest.ReadOnly =
    zio.aws.s3.model.DeleteObjectsRequest.wrap(buildAwsValue())
}
object DeleteObjectsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.DeleteObjectsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.DeleteObjectsRequest =
      zio.aws.s3.model.DeleteObjectsRequest(
        bucket,
        delete.asEditable,
        mfa.map(value => value),
        requestPayer.map(value => value),
        bypassGovernanceRetention.map(value => value),
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def delete: zio.aws.s3.model.Delete.ReadOnly
    def mfa: Option[MFA]
    def requestPayer: Option[zio.aws.s3.model.RequestPayer]
    def bypassGovernanceRetention: Option[BypassGovernanceRetention]
    def expectedBucketOwner: Option[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getDelete: ZIO[Any, Nothing, zio.aws.s3.model.Delete.ReadOnly] =
      ZIO.succeed(delete)
    def getMfa: ZIO[Any, AwsError, MFA] = AwsError.unwrapOptionField("mfa", mfa)
    def getRequestPayer: ZIO[Any, AwsError, zio.aws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayer)
    def getBypassGovernanceRetention
        : ZIO[Any, AwsError, BypassGovernanceRetention] = AwsError
      .unwrapOptionField("bypassGovernanceRetention", bypassGovernanceRetention)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.DeleteObjectsRequest
  ) extends zio.aws.s3.model.DeleteObjectsRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val delete: zio.aws.s3.model.Delete.ReadOnly =
      zio.aws.s3.model.Delete.wrap(impl.delete())
    override val mfa: Option[MFA] = scala
      .Option(impl.mfa())
      .map(value => zio.aws.s3.model.primitives.MFA(value))
    override val requestPayer: Option[zio.aws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => zio.aws.s3.model.RequestPayer.wrap(value))
    override val bypassGovernanceRetention: Option[BypassGovernanceRetention] =
      scala
        .Option(impl.bypassGovernanceRetention())
        .map(value =>
          zio.aws.s3.model.primitives.BypassGovernanceRetention(value)
        )
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.DeleteObjectsRequest
  ): zio.aws.s3.model.DeleteObjectsRequest.ReadOnly = new Wrapper(impl)
}
