package zio.aws.s3.model
import scala.jdk.CollectionConverters.*
sealed trait Event {
  def unwrap: software.amazon.awssdk.services.s3.model.Event
}
object Event {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.Event
  ): zio.aws.s3.model.Event = value match {
    case software.amazon.awssdk.services.s3.model.Event.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.Event.S3_REDUCED_REDUNDANCY_LOST_OBJECT =>
      val r = `s3:ReducedRedundancyLostObject`
      r
    case software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_CREATED =>
      val r = `s3:ObjectCreated:*`
      r
    case software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_CREATED_PUT =>
      val r = `s3:ObjectCreated:Put`
      r
    case software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_CREATED_POST =>
      val r = `s3:ObjectCreated:Post`
      r
    case software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_CREATED_COPY =>
      val r = `s3:ObjectCreated:Copy`
      r
    case software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_CREATED_COMPLETE_MULTIPART_UPLOAD =>
      val r = `s3:ObjectCreated:CompleteMultipartUpload`
      r
    case software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_REMOVED =>
      val r = `s3:ObjectRemoved:*`
      r
    case software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_REMOVED_DELETE =>
      val r = `s3:ObjectRemoved:Delete`
      r
    case software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_REMOVED_DELETE_MARKER_CREATED =>
      val r = `s3:ObjectRemoved:DeleteMarkerCreated`
      r
    case software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_RESTORE =>
      val r = `s3:ObjectRestore:*`
      r
    case software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_RESTORE_POST =>
      val r = `s3:ObjectRestore:Post`
      r
    case software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_RESTORE_COMPLETED =>
      val r = `s3:ObjectRestore:Completed`
      r
    case software.amazon.awssdk.services.s3.model.Event.S3_REPLICATION =>
      val r = `s3:Replication:*`
      r
    case software.amazon.awssdk.services.s3.model.Event.S3_REPLICATION_OPERATION_FAILED_REPLICATION =>
      val r = `s3:Replication:OperationFailedReplication`
      r
    case software.amazon.awssdk.services.s3.model.Event.S3_REPLICATION_OPERATION_NOT_TRACKED =>
      val r = `s3:Replication:OperationNotTracked`
      r
    case software.amazon.awssdk.services.s3.model.Event.S3_REPLICATION_OPERATION_MISSED_THRESHOLD =>
      val r = `s3:Replication:OperationMissedThreshold`
      r
    case software.amazon.awssdk.services.s3.model.Event.S3_REPLICATION_OPERATION_REPLICATED_AFTER_THRESHOLD =>
      val r = `s3:Replication:OperationReplicatedAfterThreshold`
      r
    case software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_RESTORE_DELETE =>
      val r = `s3:ObjectRestore:Delete`
      r
    case software.amazon.awssdk.services.s3.model.Event.S3_LIFECYCLE_TRANSITION =>
      val r = `s3:LifecycleTransition`
      r
    case software.amazon.awssdk.services.s3.model.Event.S3_INTELLIGENT_TIERING =>
      val r = `s3:IntelligentTiering`
      r
    case software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_ACL_PUT =>
      val r = `s3:ObjectAcl:Put`
      r
    case software.amazon.awssdk.services.s3.model.Event.S3_LIFECYCLE_EXPIRATION =>
      val r = `s3:LifecycleExpiration:*`
      r
    case software.amazon.awssdk.services.s3.model.Event.S3_LIFECYCLE_EXPIRATION_DELETE =>
      val r = `s3:LifecycleExpiration:Delete`
      r
    case software.amazon.awssdk.services.s3.model.Event.S3_LIFECYCLE_EXPIRATION_DELETE_MARKER_CREATED =>
      val r = `s3:LifecycleExpiration:DeleteMarkerCreated`
      r
    case software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_TAGGING =>
      val r = `s3:ObjectTagging:*`
      r
    case software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_TAGGING_PUT =>
      val r = `s3:ObjectTagging:Put`
      r
    case software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_TAGGING_DELETE =>
      val r = `s3:ObjectTagging:Delete`
      r
  }
  case object unknownToSdkVersion extends zio.aws.s3.model.Event {
    override def unwrap: software.amazon.awssdk.services.s3.model.Event =
      software.amazon.awssdk.services.s3.model.Event.UNKNOWN_TO_SDK_VERSION
  }
  case object `s3:ReducedRedundancyLostObject` extends zio.aws.s3.model.Event {
    override def unwrap: software.amazon.awssdk.services.s3.model.Event =
      software.amazon.awssdk.services.s3.model.Event.S3_REDUCED_REDUNDANCY_LOST_OBJECT
  }
  case object `s3:ObjectCreated:*` extends zio.aws.s3.model.Event {
    override def unwrap: software.amazon.awssdk.services.s3.model.Event =
      software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_CREATED
  }
  case object `s3:ObjectCreated:Put` extends zio.aws.s3.model.Event {
    override def unwrap: software.amazon.awssdk.services.s3.model.Event =
      software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_CREATED_PUT
  }
  case object `s3:ObjectCreated:Post` extends zio.aws.s3.model.Event {
    override def unwrap: software.amazon.awssdk.services.s3.model.Event =
      software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_CREATED_POST
  }
  case object `s3:ObjectCreated:Copy` extends zio.aws.s3.model.Event {
    override def unwrap: software.amazon.awssdk.services.s3.model.Event =
      software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_CREATED_COPY
  }
  case object `s3:ObjectCreated:CompleteMultipartUpload`
      extends zio.aws.s3.model.Event {
    override def unwrap: software.amazon.awssdk.services.s3.model.Event =
      software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_CREATED_COMPLETE_MULTIPART_UPLOAD
  }
  case object `s3:ObjectRemoved:*` extends zio.aws.s3.model.Event {
    override def unwrap: software.amazon.awssdk.services.s3.model.Event =
      software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_REMOVED
  }
  case object `s3:ObjectRemoved:Delete` extends zio.aws.s3.model.Event {
    override def unwrap: software.amazon.awssdk.services.s3.model.Event =
      software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_REMOVED_DELETE
  }
  case object `s3:ObjectRemoved:DeleteMarkerCreated`
      extends zio.aws.s3.model.Event {
    override def unwrap: software.amazon.awssdk.services.s3.model.Event =
      software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_REMOVED_DELETE_MARKER_CREATED
  }
  case object `s3:ObjectRestore:*` extends zio.aws.s3.model.Event {
    override def unwrap: software.amazon.awssdk.services.s3.model.Event =
      software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_RESTORE
  }
  case object `s3:ObjectRestore:Post` extends zio.aws.s3.model.Event {
    override def unwrap: software.amazon.awssdk.services.s3.model.Event =
      software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_RESTORE_POST
  }
  case object `s3:ObjectRestore:Completed` extends zio.aws.s3.model.Event {
    override def unwrap: software.amazon.awssdk.services.s3.model.Event =
      software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_RESTORE_COMPLETED
  }
  case object `s3:Replication:*` extends zio.aws.s3.model.Event {
    override def unwrap: software.amazon.awssdk.services.s3.model.Event =
      software.amazon.awssdk.services.s3.model.Event.S3_REPLICATION
  }
  case object `s3:Replication:OperationFailedReplication`
      extends zio.aws.s3.model.Event {
    override def unwrap: software.amazon.awssdk.services.s3.model.Event =
      software.amazon.awssdk.services.s3.model.Event.S3_REPLICATION_OPERATION_FAILED_REPLICATION
  }
  case object `s3:Replication:OperationNotTracked`
      extends zio.aws.s3.model.Event {
    override def unwrap: software.amazon.awssdk.services.s3.model.Event =
      software.amazon.awssdk.services.s3.model.Event.S3_REPLICATION_OPERATION_NOT_TRACKED
  }
  case object `s3:Replication:OperationMissedThreshold`
      extends zio.aws.s3.model.Event {
    override def unwrap: software.amazon.awssdk.services.s3.model.Event =
      software.amazon.awssdk.services.s3.model.Event.S3_REPLICATION_OPERATION_MISSED_THRESHOLD
  }
  case object `s3:Replication:OperationReplicatedAfterThreshold`
      extends zio.aws.s3.model.Event {
    override def unwrap: software.amazon.awssdk.services.s3.model.Event =
      software.amazon.awssdk.services.s3.model.Event.S3_REPLICATION_OPERATION_REPLICATED_AFTER_THRESHOLD
  }
  case object `s3:ObjectRestore:Delete` extends zio.aws.s3.model.Event {
    override def unwrap: software.amazon.awssdk.services.s3.model.Event =
      software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_RESTORE_DELETE
  }
  case object `s3:LifecycleTransition` extends zio.aws.s3.model.Event {
    override def unwrap: software.amazon.awssdk.services.s3.model.Event =
      software.amazon.awssdk.services.s3.model.Event.S3_LIFECYCLE_TRANSITION
  }
  case object `s3:IntelligentTiering` extends zio.aws.s3.model.Event {
    override def unwrap: software.amazon.awssdk.services.s3.model.Event =
      software.amazon.awssdk.services.s3.model.Event.S3_INTELLIGENT_TIERING
  }
  case object `s3:ObjectAcl:Put` extends zio.aws.s3.model.Event {
    override def unwrap: software.amazon.awssdk.services.s3.model.Event =
      software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_ACL_PUT
  }
  case object `s3:LifecycleExpiration:*` extends zio.aws.s3.model.Event {
    override def unwrap: software.amazon.awssdk.services.s3.model.Event =
      software.amazon.awssdk.services.s3.model.Event.S3_LIFECYCLE_EXPIRATION
  }
  case object `s3:LifecycleExpiration:Delete` extends zio.aws.s3.model.Event {
    override def unwrap: software.amazon.awssdk.services.s3.model.Event =
      software.amazon.awssdk.services.s3.model.Event.S3_LIFECYCLE_EXPIRATION_DELETE
  }
  case object `s3:LifecycleExpiration:DeleteMarkerCreated`
      extends zio.aws.s3.model.Event {
    override def unwrap: software.amazon.awssdk.services.s3.model.Event =
      software.amazon.awssdk.services.s3.model.Event.S3_LIFECYCLE_EXPIRATION_DELETE_MARKER_CREATED
  }
  case object `s3:ObjectTagging:*` extends zio.aws.s3.model.Event {
    override def unwrap: software.amazon.awssdk.services.s3.model.Event =
      software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_TAGGING
  }
  case object `s3:ObjectTagging:Put` extends zio.aws.s3.model.Event {
    override def unwrap: software.amazon.awssdk.services.s3.model.Event =
      software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_TAGGING_PUT
  }
  case object `s3:ObjectTagging:Delete` extends zio.aws.s3.model.Event {
    override def unwrap: software.amazon.awssdk.services.s3.model.Event =
      software.amazon.awssdk.services.s3.model.Event.S3_OBJECT_TAGGING_DELETE
  }
}
