package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBucketIntelligentTieringConfigurationResponse(
    intelligentTieringConfiguration: Option[
      zio.aws.s3.model.IntelligentTieringConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketIntelligentTieringConfigurationResponse = {
    import GetBucketIntelligentTieringConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketIntelligentTieringConfigurationResponse
      .builder()
      .optionallyWith(
        intelligentTieringConfiguration.map(value => value.buildAwsValue())
      )(_.intelligentTieringConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.s3.model.GetBucketIntelligentTieringConfigurationResponse.ReadOnly =
    zio.aws.s3.model.GetBucketIntelligentTieringConfigurationResponse
      .wrap(buildAwsValue())
}
object GetBucketIntelligentTieringConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketIntelligentTieringConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3.model.GetBucketIntelligentTieringConfigurationResponse =
      zio.aws.s3.model.GetBucketIntelligentTieringConfigurationResponse(
        intelligentTieringConfiguration.map(value => value.asEditable)
      )
    def intelligentTieringConfiguration
        : Option[zio.aws.s3.model.IntelligentTieringConfiguration.ReadOnly]
    def getIntelligentTieringConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.IntelligentTieringConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "intelligentTieringConfiguration",
      intelligentTieringConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketIntelligentTieringConfigurationResponse
  ) extends zio.aws.s3.model.GetBucketIntelligentTieringConfigurationResponse.ReadOnly {
    override val intelligentTieringConfiguration
        : Option[zio.aws.s3.model.IntelligentTieringConfiguration.ReadOnly] =
      scala
        .Option(impl.intelligentTieringConfiguration())
        .map(value =>
          zio.aws.s3.model.IntelligentTieringConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketIntelligentTieringConfigurationResponse
  ): zio.aws.s3.model.GetBucketIntelligentTieringConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
