package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBucketInventoryConfigurationResponse(
    inventoryConfiguration: Option[zio.aws.s3.model.InventoryConfiguration] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationResponse = {
    import GetBucketInventoryConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationResponse
      .builder()
      .optionallyWith(
        inventoryConfiguration.map(value => value.buildAwsValue())
      )(_.inventoryConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.s3.model.GetBucketInventoryConfigurationResponse.ReadOnly =
    zio.aws.s3.model.GetBucketInventoryConfigurationResponse
      .wrap(buildAwsValue())
}
object GetBucketInventoryConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetBucketInventoryConfigurationResponse =
      zio.aws.s3.model.GetBucketInventoryConfigurationResponse(
        inventoryConfiguration.map(value => value.asEditable)
      )
    def inventoryConfiguration
        : Option[zio.aws.s3.model.InventoryConfiguration.ReadOnly]
    def getInventoryConfiguration
        : ZIO[Any, AwsError, zio.aws.s3.model.InventoryConfiguration.ReadOnly] =
      AwsError.unwrapOptionField(
        "inventoryConfiguration",
        inventoryConfiguration
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationResponse
  ) extends zio.aws.s3.model.GetBucketInventoryConfigurationResponse.ReadOnly {
    override val inventoryConfiguration
        : Option[zio.aws.s3.model.InventoryConfiguration.ReadOnly] = scala
      .Option(impl.inventoryConfiguration())
      .map(value => zio.aws.s3.model.InventoryConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationResponse
  ): zio.aws.s3.model.GetBucketInventoryConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
