package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBucketNotificationConfigurationResponse(
    topicConfigurations: Option[Iterable[zio.aws.s3.model.TopicConfiguration]] =
      None,
    queueConfigurations: Option[Iterable[zio.aws.s3.model.QueueConfiguration]] =
      None,
    lambdaFunctionConfigurations: Option[
      Iterable[zio.aws.s3.model.LambdaFunctionConfiguration]
    ] = None,
    eventBridgeConfiguration: Option[
      zio.aws.s3.model.EventBridgeConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketNotificationConfigurationResponse = {
    import GetBucketNotificationConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketNotificationConfigurationResponse
      .builder()
      .optionallyWith(
        topicConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.topicConfigurations)
      .optionallyWith(
        queueConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.queueConfigurations)
      .optionallyWith(
        lambdaFunctionConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lambdaFunctionConfigurations)
      .optionallyWith(
        eventBridgeConfiguration.map(value => value.buildAwsValue())
      )(_.eventBridgeConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.s3.model.GetBucketNotificationConfigurationResponse.ReadOnly =
    zio.aws.s3.model.GetBucketNotificationConfigurationResponse
      .wrap(buildAwsValue())
}
object GetBucketNotificationConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketNotificationConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3.model.GetBucketNotificationConfigurationResponse =
      zio.aws.s3.model.GetBucketNotificationConfigurationResponse(
        topicConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        queueConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lambdaFunctionConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        eventBridgeConfiguration.map(value => value.asEditable)
      )
    def topicConfigurations
        : Option[List[zio.aws.s3.model.TopicConfiguration.ReadOnly]]
    def queueConfigurations
        : Option[List[zio.aws.s3.model.QueueConfiguration.ReadOnly]]
    def lambdaFunctionConfigurations
        : Option[List[zio.aws.s3.model.LambdaFunctionConfiguration.ReadOnly]]
    def eventBridgeConfiguration
        : Option[zio.aws.s3.model.EventBridgeConfiguration.ReadOnly]
    def getTopicConfigurations: ZIO[Any, AwsError, List[
      zio.aws.s3.model.TopicConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("topicConfigurations", topicConfigurations)
    def getQueueConfigurations: ZIO[Any, AwsError, List[
      zio.aws.s3.model.QueueConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("queueConfigurations", queueConfigurations)
    def getLambdaFunctionConfigurations: ZIO[Any, AwsError, List[
      zio.aws.s3.model.LambdaFunctionConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "lambdaFunctionConfigurations",
      lambdaFunctionConfigurations
    )
    def getEventBridgeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.EventBridgeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "eventBridgeConfiguration",
      eventBridgeConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketNotificationConfigurationResponse
  ) extends zio.aws.s3.model.GetBucketNotificationConfigurationResponse.ReadOnly {
    override val topicConfigurations
        : Option[List[zio.aws.s3.model.TopicConfiguration.ReadOnly]] = scala
      .Option(impl.topicConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3.model.TopicConfiguration.wrap(item)
        }.toList
      )
    override val queueConfigurations
        : Option[List[zio.aws.s3.model.QueueConfiguration.ReadOnly]] = scala
      .Option(impl.queueConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3.model.QueueConfiguration.wrap(item)
        }.toList
      )
    override val lambdaFunctionConfigurations
        : Option[List[zio.aws.s3.model.LambdaFunctionConfiguration.ReadOnly]] =
      scala
        .Option(impl.lambdaFunctionConfigurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.LambdaFunctionConfiguration.wrap(item)
          }.toList
        )
    override val eventBridgeConfiguration
        : Option[zio.aws.s3.model.EventBridgeConfiguration.ReadOnly] = scala
      .Option(impl.eventBridgeConfiguration())
      .map(value => zio.aws.s3.model.EventBridgeConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketNotificationConfigurationResponse
  ): zio.aws.s3.model.GetBucketNotificationConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
