package zio.aws.s3.model
import zio.aws.s3.model.primitives.Policy
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBucketPolicyResponse(policy: Option[Policy] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketPolicyResponse = {
    import GetBucketPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketPolicyResponse
      .builder()
      .optionallyWith(
        policy.map(value => Policy.unwrap(value): java.lang.String)
      )(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.GetBucketPolicyResponse.ReadOnly =
    zio.aws.s3.model.GetBucketPolicyResponse.wrap(buildAwsValue())
}
object GetBucketPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetBucketPolicyResponse =
      zio.aws.s3.model.GetBucketPolicyResponse(policy.map(value => value))
    def policy: Option[Policy]
    def getPolicy: ZIO[Any, AwsError, Policy] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketPolicyResponse
  ) extends zio.aws.s3.model.GetBucketPolicyResponse.ReadOnly {
    override val policy: Option[Policy] = scala
      .Option(impl.policy())
      .map(value => zio.aws.s3.model.primitives.Policy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketPolicyResponse
  ): zio.aws.s3.model.GetBucketPolicyResponse.ReadOnly = new Wrapper(impl)
}
