package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBucketRequestPaymentResponse(
    payer: Option[zio.aws.s3.model.Payer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketRequestPaymentResponse = {
    import GetBucketRequestPaymentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketRequestPaymentResponse
      .builder()
      .optionallyWith(payer.map(value => value.unwrap))(_.payer)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.GetBucketRequestPaymentResponse.ReadOnly =
    zio.aws.s3.model.GetBucketRequestPaymentResponse.wrap(buildAwsValue())
}
object GetBucketRequestPaymentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketRequestPaymentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetBucketRequestPaymentResponse =
      zio.aws.s3.model
        .GetBucketRequestPaymentResponse(payer.map(value => value))
    def payer: Option[zio.aws.s3.model.Payer]
    def getPayer: ZIO[Any, AwsError, zio.aws.s3.model.Payer] =
      AwsError.unwrapOptionField("payer", payer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketRequestPaymentResponse
  ) extends zio.aws.s3.model.GetBucketRequestPaymentResponse.ReadOnly {
    override val payer: Option[zio.aws.s3.model.Payer] = scala
      .Option(impl.payer())
      .map(value => zio.aws.s3.model.Payer.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketRequestPaymentResponse
  ): zio.aws.s3.model.GetBucketRequestPaymentResponse.ReadOnly = new Wrapper(
    impl
  )
}
