package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetObjectLegalHoldResponse(
    legalHold: Option[zio.aws.s3.model.ObjectLockLegalHold] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetObjectLegalHoldResponse = {
    import GetObjectLegalHoldResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetObjectLegalHoldResponse
      .builder()
      .optionallyWith(legalHold.map(value => value.buildAwsValue()))(
        _.legalHold
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.GetObjectLegalHoldResponse.ReadOnly =
    zio.aws.s3.model.GetObjectLegalHoldResponse.wrap(buildAwsValue())
}
object GetObjectLegalHoldResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetObjectLegalHoldResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetObjectLegalHoldResponse =
      zio.aws.s3.model
        .GetObjectLegalHoldResponse(legalHold.map(value => value.asEditable))
    def legalHold: Option[zio.aws.s3.model.ObjectLockLegalHold.ReadOnly]
    def getLegalHold
        : ZIO[Any, AwsError, zio.aws.s3.model.ObjectLockLegalHold.ReadOnly] =
      AwsError.unwrapOptionField("legalHold", legalHold)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetObjectLegalHoldResponse
  ) extends zio.aws.s3.model.GetObjectLegalHoldResponse.ReadOnly {
    override val legalHold
        : Option[zio.aws.s3.model.ObjectLockLegalHold.ReadOnly] = scala
      .Option(impl.legalHold())
      .map(value => zio.aws.s3.model.ObjectLockLegalHold.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetObjectLegalHoldResponse
  ): zio.aws.s3.model.GetObjectLegalHoldResponse.ReadOnly = new Wrapper(impl)
}
