package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  AccountId,
  ObjectVersionId,
  ObjectKey,
  BucketName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetObjectTaggingRequest(
    bucket: BucketName,
    key: ObjectKey,
    versionId: Option[ObjectVersionId] = None,
    expectedBucketOwner: Option[AccountId] = None,
    requestPayer: Option[zio.aws.s3.model.RequestPayer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetObjectTaggingRequest = {
    import GetObjectTaggingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetObjectTaggingRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .key(ObjectKey.unwrap(key): java.lang.String)
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.GetObjectTaggingRequest.ReadOnly =
    zio.aws.s3.model.GetObjectTaggingRequest.wrap(buildAwsValue())
}
object GetObjectTaggingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetObjectTaggingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetObjectTaggingRequest =
      zio.aws.s3.model.GetObjectTaggingRequest(
        bucket,
        key,
        versionId.map(value => value),
        expectedBucketOwner.map(value => value),
        requestPayer.map(value => value)
      )
    def bucket: BucketName
    def key: ObjectKey
    def versionId: Option[ObjectVersionId]
    def expectedBucketOwner: Option[AccountId]
    def requestPayer: Option[zio.aws.s3.model.RequestPayer]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getKey: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(key)
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
    def getRequestPayer: ZIO[Any, AwsError, zio.aws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetObjectTaggingRequest
  ) extends zio.aws.s3.model.GetObjectTaggingRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val key: ObjectKey =
      zio.aws.s3.model.primitives.ObjectKey(impl.key())
    override val versionId: Option[ObjectVersionId] = scala
      .Option(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
    override val requestPayer: Option[zio.aws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => zio.aws.s3.model.RequestPayer.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetObjectTaggingRequest
  ): zio.aws.s3.model.GetObjectTaggingRequest.ReadOnly = new Wrapper(impl)
}
