package zio.aws.s3.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{
  SSECustomerKey,
  AccountId,
  SSECustomerAlgorithm,
  IfModifiedSince,
  IfNoneMatch,
  IfMatch,
  SSECustomerKeyMD5,
  ObjectKey,
  BucketName,
  IfUnmodifiedSince,
  ObjectVersionId,
  PartNumber
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class HeadObjectRequest(
    bucket: BucketName,
    ifMatch: Option[IfMatch] = None,
    ifModifiedSince: Option[IfModifiedSince] = None,
    ifNoneMatch: Option[IfNoneMatch] = None,
    ifUnmodifiedSince: Option[IfUnmodifiedSince] = None,
    key: ObjectKey,
    range: Option[zio.aws.s3.model.primitives.Range] = None,
    versionId: Option[ObjectVersionId] = None,
    sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = None,
    sseCustomerKey: Option[SSECustomerKey] = None,
    sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = None,
    requestPayer: Option[zio.aws.s3.model.RequestPayer] = None,
    partNumber: Option[PartNumber] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.HeadObjectRequest = {
    import HeadObjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.HeadObjectRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        ifMatch.map(value => IfMatch.unwrap(value): java.lang.String)
      )(_.ifMatch)
      .optionallyWith(
        ifModifiedSince.map(value => IfModifiedSince.unwrap(value): Instant)
      )(_.ifModifiedSince)
      .optionallyWith(
        ifNoneMatch.map(value => IfNoneMatch.unwrap(value): java.lang.String)
      )(_.ifNoneMatch)
      .optionallyWith(
        ifUnmodifiedSince.map(value => IfUnmodifiedSince.unwrap(value): Instant)
      )(_.ifUnmodifiedSince)
      .key(ObjectKey.unwrap(key): java.lang.String)
      .optionallyWith(
        range.map(value =>
          zio.aws.s3.model.primitives.Range.unwrap(value): java.lang.String
        )
      )(_.range)
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(
        sseCustomerAlgorithm.map(value =>
          SSECustomerAlgorithm.unwrap(value): java.lang.String
        )
      )(_.sseCustomerAlgorithm)
      .optionallyWith(
        sseCustomerKey.map(value =>
          SSECustomerKey.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKey)
      .optionallyWith(
        sseCustomerKeyMD5.map(value =>
          SSECustomerKeyMD5.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKeyMD5)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        partNumber.map(value => PartNumber.unwrap(value): Integer)
      )(_.partNumber)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.HeadObjectRequest.ReadOnly =
    zio.aws.s3.model.HeadObjectRequest.wrap(buildAwsValue())
}
object HeadObjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.HeadObjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.HeadObjectRequest =
      zio.aws.s3.model.HeadObjectRequest(
        bucket,
        ifMatch.map(value => value),
        ifModifiedSince.map(value => value),
        ifNoneMatch.map(value => value),
        ifUnmodifiedSince.map(value => value),
        key,
        range.map(value => value),
        versionId.map(value => value),
        sseCustomerAlgorithm.map(value => value),
        sseCustomerKey.map(value => value),
        sseCustomerKeyMD5.map(value => value),
        requestPayer.map(value => value),
        partNumber.map(value => value),
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def ifMatch: Option[IfMatch]
    def ifModifiedSince: Option[IfModifiedSince]
    def ifNoneMatch: Option[IfNoneMatch]
    def ifUnmodifiedSince: Option[IfUnmodifiedSince]
    def key: ObjectKey
    def range: Option[zio.aws.s3.model.primitives.Range]
    def versionId: Option[ObjectVersionId]
    def sseCustomerAlgorithm: Option[SSECustomerAlgorithm]
    def sseCustomerKey: Option[SSECustomerKey]
    def sseCustomerKeyMD5: Option[SSECustomerKeyMD5]
    def requestPayer: Option[zio.aws.s3.model.RequestPayer]
    def partNumber: Option[PartNumber]
    def expectedBucketOwner: Option[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getIfMatch: ZIO[Any, AwsError, IfMatch] =
      AwsError.unwrapOptionField("ifMatch", ifMatch)
    def getIfModifiedSince: ZIO[Any, AwsError, IfModifiedSince] =
      AwsError.unwrapOptionField("ifModifiedSince", ifModifiedSince)
    def getIfNoneMatch: ZIO[Any, AwsError, IfNoneMatch] =
      AwsError.unwrapOptionField("ifNoneMatch", ifNoneMatch)
    def getIfUnmodifiedSince: ZIO[Any, AwsError, IfUnmodifiedSince] =
      AwsError.unwrapOptionField("ifUnmodifiedSince", ifUnmodifiedSince)
    def getKey: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(key)
    def getRange: ZIO[Any, AwsError, zio.aws.s3.model.primitives.Range] =
      AwsError.unwrapOptionField("range", range)
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getSseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField("sseCustomerAlgorithm", sseCustomerAlgorithm)
    def getSseCustomerKey: ZIO[Any, AwsError, SSECustomerKey] =
      AwsError.unwrapOptionField("sseCustomerKey", sseCustomerKey)
    def getSseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5)
    def getRequestPayer: ZIO[Any, AwsError, zio.aws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayer)
    def getPartNumber: ZIO[Any, AwsError, PartNumber] =
      AwsError.unwrapOptionField("partNumber", partNumber)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.HeadObjectRequest
  ) extends zio.aws.s3.model.HeadObjectRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val ifMatch: Option[IfMatch] = scala
      .Option(impl.ifMatch())
      .map(value => zio.aws.s3.model.primitives.IfMatch(value))
    override val ifModifiedSince: Option[IfModifiedSince] = scala
      .Option(impl.ifModifiedSince())
      .map(value => zio.aws.s3.model.primitives.IfModifiedSince(value))
    override val ifNoneMatch: Option[IfNoneMatch] = scala
      .Option(impl.ifNoneMatch())
      .map(value => zio.aws.s3.model.primitives.IfNoneMatch(value))
    override val ifUnmodifiedSince: Option[IfUnmodifiedSince] = scala
      .Option(impl.ifUnmodifiedSince())
      .map(value => zio.aws.s3.model.primitives.IfUnmodifiedSince(value))
    override val key: ObjectKey =
      zio.aws.s3.model.primitives.ObjectKey(impl.key())
    override val range: Option[zio.aws.s3.model.primitives.Range] = scala
      .Option(impl.range())
      .map(value => zio.aws.s3.model.primitives.Range(value))
    override val versionId: Option[ObjectVersionId] = scala
      .Option(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
    override val sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = scala
      .Option(impl.sseCustomerAlgorithm())
      .map(value => zio.aws.s3.model.primitives.SSECustomerAlgorithm(value))
    override val sseCustomerKey: Option[SSECustomerKey] = scala
      .Option(impl.sseCustomerKey())
      .map(value => zio.aws.s3.model.primitives.SSECustomerKey(value))
    override val sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = scala
      .Option(impl.sseCustomerKeyMD5())
      .map(value => zio.aws.s3.model.primitives.SSECustomerKeyMD5(value))
    override val requestPayer: Option[zio.aws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => zio.aws.s3.model.RequestPayer.wrap(value))
    override val partNumber: Option[PartNumber] = scala
      .Option(impl.partNumber())
      .map(value => zio.aws.s3.model.primitives.PartNumber(value))
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.HeadObjectRequest
  ): zio.aws.s3.model.HeadObjectRequest.ReadOnly = new Wrapper(impl)
}
