package zio.aws.s3.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{
  ContentType,
  ETag,
  CacheControl,
  WebsiteRedirectLocation,
  AcceptRanges,
  ContentDisposition,
  ContentLanguage,
  Expiration,
  ContentLength,
  PartsCount,
  SSECustomerAlgorithm,
  SSECustomerKeyMD5,
  DeleteMarker,
  LastModified,
  Expires,
  ContentEncoding,
  MissingMeta,
  SSEKMSKeyId,
  MetadataValue,
  ObjectLockRetainUntilDate,
  Restore,
  ObjectVersionId,
  MetadataKey,
  BucketKeyEnabled
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class HeadObjectResponse(
    deleteMarker: Option[DeleteMarker] = None,
    acceptRanges: Option[AcceptRanges] = None,
    expiration: Option[Expiration] = None,
    restore: Option[Restore] = None,
    archiveStatus: Option[zio.aws.s3.model.ArchiveStatus] = None,
    lastModified: Option[LastModified] = None,
    contentLength: Option[ContentLength] = None,
    eTag: Option[ETag] = None,
    missingMeta: Option[MissingMeta] = None,
    versionId: Option[ObjectVersionId] = None,
    cacheControl: Option[CacheControl] = None,
    contentDisposition: Option[ContentDisposition] = None,
    contentEncoding: Option[ContentEncoding] = None,
    contentLanguage: Option[ContentLanguage] = None,
    contentType: Option[ContentType] = None,
    expires: Option[Expires] = None,
    websiteRedirectLocation: Option[WebsiteRedirectLocation] = None,
    serverSideEncryption: Option[zio.aws.s3.model.ServerSideEncryption] = None,
    metadata: Option[Map[MetadataKey, MetadataValue]] = None,
    sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = None,
    sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = None,
    ssekmsKeyId: Option[SSEKMSKeyId] = None,
    bucketKeyEnabled: Option[BucketKeyEnabled] = None,
    storageClass: Option[zio.aws.s3.model.StorageClass] = None,
    requestCharged: Option[zio.aws.s3.model.RequestCharged] = None,
    replicationStatus: Option[zio.aws.s3.model.ReplicationStatus] = None,
    partsCount: Option[PartsCount] = None,
    objectLockMode: Option[zio.aws.s3.model.ObjectLockMode] = None,
    objectLockRetainUntilDate: Option[ObjectLockRetainUntilDate] = None,
    objectLockLegalHoldStatus: Option[
      zio.aws.s3.model.ObjectLockLegalHoldStatus
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.HeadObjectResponse = {
    import HeadObjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.HeadObjectResponse
      .builder()
      .optionallyWith(
        deleteMarker.map(value => DeleteMarker.unwrap(value): java.lang.Boolean)
      )(_.deleteMarker)
      .optionallyWith(
        acceptRanges.map(value => AcceptRanges.unwrap(value): java.lang.String)
      )(_.acceptRanges)
      .optionallyWith(
        expiration.map(value => Expiration.unwrap(value): java.lang.String)
      )(_.expiration)
      .optionallyWith(
        restore.map(value => Restore.unwrap(value): java.lang.String)
      )(_.restore)
      .optionallyWith(archiveStatus.map(value => value.unwrap))(_.archiveStatus)
      .optionallyWith(
        lastModified.map(value => LastModified.unwrap(value): Instant)
      )(_.lastModified)
      .optionallyWith(
        contentLength.map(value => ContentLength.unwrap(value): java.lang.Long)
      )(_.contentLength)
      .optionallyWith(eTag.map(value => ETag.unwrap(value): java.lang.String))(
        _.eTag
      )
      .optionallyWith(
        missingMeta.map(value => MissingMeta.unwrap(value): Integer)
      )(_.missingMeta)
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(
        cacheControl.map(value => CacheControl.unwrap(value): java.lang.String)
      )(_.cacheControl)
      .optionallyWith(
        contentDisposition.map(value =>
          ContentDisposition.unwrap(value): java.lang.String
        )
      )(_.contentDisposition)
      .optionallyWith(
        contentEncoding.map(value =>
          ContentEncoding.unwrap(value): java.lang.String
        )
      )(_.contentEncoding)
      .optionallyWith(
        contentLanguage.map(value =>
          ContentLanguage.unwrap(value): java.lang.String
        )
      )(_.contentLanguage)
      .optionallyWith(
        contentType.map(value => ContentType.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(expires.map(value => Expires.unwrap(value): Instant))(
        _.expires
      )
      .optionallyWith(
        websiteRedirectLocation.map(value =>
          WebsiteRedirectLocation.unwrap(value): java.lang.String
        )
      )(_.websiteRedirectLocation)
      .optionallyWith(serverSideEncryption.map(value => value.unwrap))(
        _.serverSideEncryption
      )
      .optionallyWith(
        metadata.map(value =>
          value
            .map({ case (key, value) =>
              (MetadataKey.unwrap(key): java.lang.String) -> (MetadataValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.metadata)
      .optionallyWith(
        sseCustomerAlgorithm.map(value =>
          SSECustomerAlgorithm.unwrap(value): java.lang.String
        )
      )(_.sseCustomerAlgorithm)
      .optionallyWith(
        sseCustomerKeyMD5.map(value =>
          SSECustomerKeyMD5.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKeyMD5)
      .optionallyWith(
        ssekmsKeyId.map(value => SSEKMSKeyId.unwrap(value): java.lang.String)
      )(_.ssekmsKeyId)
      .optionallyWith(
        bucketKeyEnabled.map(value =>
          BucketKeyEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.bucketKeyEnabled)
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .optionallyWith(replicationStatus.map(value => value.unwrap))(
        _.replicationStatus
      )
      .optionallyWith(
        partsCount.map(value => PartsCount.unwrap(value): Integer)
      )(_.partsCount)
      .optionallyWith(objectLockMode.map(value => value.unwrap))(
        _.objectLockMode
      )
      .optionallyWith(
        objectLockRetainUntilDate.map(value =>
          ObjectLockRetainUntilDate.unwrap(value): Instant
        )
      )(_.objectLockRetainUntilDate)
      .optionallyWith(objectLockLegalHoldStatus.map(value => value.unwrap))(
        _.objectLockLegalHoldStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.HeadObjectResponse.ReadOnly =
    zio.aws.s3.model.HeadObjectResponse.wrap(buildAwsValue())
}
object HeadObjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.HeadObjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.HeadObjectResponse =
      zio.aws.s3.model.HeadObjectResponse(
        deleteMarker.map(value => value),
        acceptRanges.map(value => value),
        expiration.map(value => value),
        restore.map(value => value),
        archiveStatus.map(value => value),
        lastModified.map(value => value),
        contentLength.map(value => value),
        eTag.map(value => value),
        missingMeta.map(value => value),
        versionId.map(value => value),
        cacheControl.map(value => value),
        contentDisposition.map(value => value),
        contentEncoding.map(value => value),
        contentLanguage.map(value => value),
        contentType.map(value => value),
        expires.map(value => value),
        websiteRedirectLocation.map(value => value),
        serverSideEncryption.map(value => value),
        metadata.map(value => value),
        sseCustomerAlgorithm.map(value => value),
        sseCustomerKeyMD5.map(value => value),
        ssekmsKeyId.map(value => value),
        bucketKeyEnabled.map(value => value),
        storageClass.map(value => value),
        requestCharged.map(value => value),
        replicationStatus.map(value => value),
        partsCount.map(value => value),
        objectLockMode.map(value => value),
        objectLockRetainUntilDate.map(value => value),
        objectLockLegalHoldStatus.map(value => value)
      )
    def deleteMarker: Option[DeleteMarker]
    def acceptRanges: Option[AcceptRanges]
    def expiration: Option[Expiration]
    def restore: Option[Restore]
    def archiveStatus: Option[zio.aws.s3.model.ArchiveStatus]
    def lastModified: Option[LastModified]
    def contentLength: Option[ContentLength]
    def eTag: Option[ETag]
    def missingMeta: Option[MissingMeta]
    def versionId: Option[ObjectVersionId]
    def cacheControl: Option[CacheControl]
    def contentDisposition: Option[ContentDisposition]
    def contentEncoding: Option[ContentEncoding]
    def contentLanguage: Option[ContentLanguage]
    def contentType: Option[ContentType]
    def expires: Option[Expires]
    def websiteRedirectLocation: Option[WebsiteRedirectLocation]
    def serverSideEncryption: Option[zio.aws.s3.model.ServerSideEncryption]
    def metadata: Option[Map[MetadataKey, MetadataValue]]
    def sseCustomerAlgorithm: Option[SSECustomerAlgorithm]
    def sseCustomerKeyMD5: Option[SSECustomerKeyMD5]
    def ssekmsKeyId: Option[SSEKMSKeyId]
    def bucketKeyEnabled: Option[BucketKeyEnabled]
    def storageClass: Option[zio.aws.s3.model.StorageClass]
    def requestCharged: Option[zio.aws.s3.model.RequestCharged]
    def replicationStatus: Option[zio.aws.s3.model.ReplicationStatus]
    def partsCount: Option[PartsCount]
    def objectLockMode: Option[zio.aws.s3.model.ObjectLockMode]
    def objectLockRetainUntilDate: Option[ObjectLockRetainUntilDate]
    def objectLockLegalHoldStatus
        : Option[zio.aws.s3.model.ObjectLockLegalHoldStatus]
    def getDeleteMarker: ZIO[Any, AwsError, DeleteMarker] =
      AwsError.unwrapOptionField("deleteMarker", deleteMarker)
    def getAcceptRanges: ZIO[Any, AwsError, AcceptRanges] =
      AwsError.unwrapOptionField("acceptRanges", acceptRanges)
    def getExpiration: ZIO[Any, AwsError, Expiration] =
      AwsError.unwrapOptionField("expiration", expiration)
    def getRestore: ZIO[Any, AwsError, Restore] =
      AwsError.unwrapOptionField("restore", restore)
    def getArchiveStatus: ZIO[Any, AwsError, zio.aws.s3.model.ArchiveStatus] =
      AwsError.unwrapOptionField("archiveStatus", archiveStatus)
    def getLastModified: ZIO[Any, AwsError, LastModified] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getContentLength: ZIO[Any, AwsError, ContentLength] =
      AwsError.unwrapOptionField("contentLength", contentLength)
    def getETag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getMissingMeta: ZIO[Any, AwsError, MissingMeta] =
      AwsError.unwrapOptionField("missingMeta", missingMeta)
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getCacheControl: ZIO[Any, AwsError, CacheControl] =
      AwsError.unwrapOptionField("cacheControl", cacheControl)
    def getContentDisposition: ZIO[Any, AwsError, ContentDisposition] =
      AwsError.unwrapOptionField("contentDisposition", contentDisposition)
    def getContentEncoding: ZIO[Any, AwsError, ContentEncoding] =
      AwsError.unwrapOptionField("contentEncoding", contentEncoding)
    def getContentLanguage: ZIO[Any, AwsError, ContentLanguage] =
      AwsError.unwrapOptionField("contentLanguage", contentLanguage)
    def getContentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getExpires: ZIO[Any, AwsError, Expires] =
      AwsError.unwrapOptionField("expires", expires)
    def getWebsiteRedirectLocation
        : ZIO[Any, AwsError, WebsiteRedirectLocation] = AwsError
      .unwrapOptionField("websiteRedirectLocation", websiteRedirectLocation)
    def getServerSideEncryption
        : ZIO[Any, AwsError, zio.aws.s3.model.ServerSideEncryption] =
      AwsError.unwrapOptionField("serverSideEncryption", serverSideEncryption)
    def getMetadata: ZIO[Any, AwsError, Map[MetadataKey, MetadataValue]] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getSseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField("sseCustomerAlgorithm", sseCustomerAlgorithm)
    def getSseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5)
    def getSsekmsKeyId: ZIO[Any, AwsError, SSEKMSKeyId] =
      AwsError.unwrapOptionField("ssekmsKeyId", ssekmsKeyId)
    def getBucketKeyEnabled: ZIO[Any, AwsError, BucketKeyEnabled] =
      AwsError.unwrapOptionField("bucketKeyEnabled", bucketKeyEnabled)
    def getStorageClass: ZIO[Any, AwsError, zio.aws.s3.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getRequestCharged: ZIO[Any, AwsError, zio.aws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestCharged)
    def getReplicationStatus
        : ZIO[Any, AwsError, zio.aws.s3.model.ReplicationStatus] =
      AwsError.unwrapOptionField("replicationStatus", replicationStatus)
    def getPartsCount: ZIO[Any, AwsError, PartsCount] =
      AwsError.unwrapOptionField("partsCount", partsCount)
    def getObjectLockMode: ZIO[Any, AwsError, zio.aws.s3.model.ObjectLockMode] =
      AwsError.unwrapOptionField("objectLockMode", objectLockMode)
    def getObjectLockRetainUntilDate
        : ZIO[Any, AwsError, ObjectLockRetainUntilDate] = AwsError
      .unwrapOptionField("objectLockRetainUntilDate", objectLockRetainUntilDate)
    def getObjectLockLegalHoldStatus
        : ZIO[Any, AwsError, zio.aws.s3.model.ObjectLockLegalHoldStatus] =
      AwsError.unwrapOptionField(
        "objectLockLegalHoldStatus",
        objectLockLegalHoldStatus
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.HeadObjectResponse
  ) extends zio.aws.s3.model.HeadObjectResponse.ReadOnly {
    override val deleteMarker: Option[DeleteMarker] = scala
      .Option(impl.deleteMarker())
      .map(value => zio.aws.s3.model.primitives.DeleteMarker(value))
    override val acceptRanges: Option[AcceptRanges] = scala
      .Option(impl.acceptRanges())
      .map(value => zio.aws.s3.model.primitives.AcceptRanges(value))
    override val expiration: Option[Expiration] = scala
      .Option(impl.expiration())
      .map(value => zio.aws.s3.model.primitives.Expiration(value))
    override val restore: Option[Restore] = scala
      .Option(impl.restore())
      .map(value => zio.aws.s3.model.primitives.Restore(value))
    override val archiveStatus: Option[zio.aws.s3.model.ArchiveStatus] = scala
      .Option(impl.archiveStatus())
      .map(value => zio.aws.s3.model.ArchiveStatus.wrap(value))
    override val lastModified: Option[LastModified] = scala
      .Option(impl.lastModified())
      .map(value => zio.aws.s3.model.primitives.LastModified(value))
    override val contentLength: Option[ContentLength] = scala
      .Option(impl.contentLength())
      .map(value => zio.aws.s3.model.primitives.ContentLength(value))
    override val eTag: Option[ETag] = scala
      .Option(impl.eTag())
      .map(value => zio.aws.s3.model.primitives.ETag(value))
    override val missingMeta: Option[MissingMeta] = scala
      .Option(impl.missingMeta())
      .map(value => zio.aws.s3.model.primitives.MissingMeta(value))
    override val versionId: Option[ObjectVersionId] = scala
      .Option(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
    override val cacheControl: Option[CacheControl] = scala
      .Option(impl.cacheControl())
      .map(value => zio.aws.s3.model.primitives.CacheControl(value))
    override val contentDisposition: Option[ContentDisposition] = scala
      .Option(impl.contentDisposition())
      .map(value => zio.aws.s3.model.primitives.ContentDisposition(value))
    override val contentEncoding: Option[ContentEncoding] = scala
      .Option(impl.contentEncoding())
      .map(value => zio.aws.s3.model.primitives.ContentEncoding(value))
    override val contentLanguage: Option[ContentLanguage] = scala
      .Option(impl.contentLanguage())
      .map(value => zio.aws.s3.model.primitives.ContentLanguage(value))
    override val contentType: Option[ContentType] = scala
      .Option(impl.contentType())
      .map(value => zio.aws.s3.model.primitives.ContentType(value))
    override val expires: Option[Expires] = scala
      .Option(impl.expires())
      .map(value => zio.aws.s3.model.primitives.Expires(value))
    override val websiteRedirectLocation: Option[WebsiteRedirectLocation] =
      scala
        .Option(impl.websiteRedirectLocation())
        .map(value =>
          zio.aws.s3.model.primitives.WebsiteRedirectLocation(value)
        )
    override val serverSideEncryption
        : Option[zio.aws.s3.model.ServerSideEncryption] = scala
      .Option(impl.serverSideEncryption())
      .map(value => zio.aws.s3.model.ServerSideEncryption.wrap(value))
    override val metadata: Option[Map[MetadataKey, MetadataValue]] = scala
      .Option(impl.metadata())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.s3.model.primitives.MetadataKey(
              key
            ) -> zio.aws.s3.model.primitives.MetadataValue(value)
          })
          .toMap
      )
    override val sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = scala
      .Option(impl.sseCustomerAlgorithm())
      .map(value => zio.aws.s3.model.primitives.SSECustomerAlgorithm(value))
    override val sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = scala
      .Option(impl.sseCustomerKeyMD5())
      .map(value => zio.aws.s3.model.primitives.SSECustomerKeyMD5(value))
    override val ssekmsKeyId: Option[SSEKMSKeyId] = scala
      .Option(impl.ssekmsKeyId())
      .map(value => zio.aws.s3.model.primitives.SSEKMSKeyId(value))
    override val bucketKeyEnabled: Option[BucketKeyEnabled] = scala
      .Option(impl.bucketKeyEnabled())
      .map(value => zio.aws.s3.model.primitives.BucketKeyEnabled(value))
    override val storageClass: Option[zio.aws.s3.model.StorageClass] = scala
      .Option(impl.storageClass())
      .map(value => zio.aws.s3.model.StorageClass.wrap(value))
    override val requestCharged: Option[zio.aws.s3.model.RequestCharged] = scala
      .Option(impl.requestCharged())
      .map(value => zio.aws.s3.model.RequestCharged.wrap(value))
    override val replicationStatus: Option[zio.aws.s3.model.ReplicationStatus] =
      scala
        .Option(impl.replicationStatus())
        .map(value => zio.aws.s3.model.ReplicationStatus.wrap(value))
    override val partsCount: Option[PartsCount] = scala
      .Option(impl.partsCount())
      .map(value => zio.aws.s3.model.primitives.PartsCount(value))
    override val objectLockMode: Option[zio.aws.s3.model.ObjectLockMode] = scala
      .Option(impl.objectLockMode())
      .map(value => zio.aws.s3.model.ObjectLockMode.wrap(value))
    override val objectLockRetainUntilDate: Option[ObjectLockRetainUntilDate] =
      scala
        .Option(impl.objectLockRetainUntilDate())
        .map(value =>
          zio.aws.s3.model.primitives.ObjectLockRetainUntilDate(value)
        )
    override val objectLockLegalHoldStatus
        : Option[zio.aws.s3.model.ObjectLockLegalHoldStatus] = scala
      .Option(impl.objectLockLegalHoldStatus())
      .map(value => zio.aws.s3.model.ObjectLockLegalHoldStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.HeadObjectResponse
  ): zio.aws.s3.model.HeadObjectResponse.ReadOnly = new Wrapper(impl)
}
