package zio.aws.s3.model
import zio.aws.s3.model.primitives.IntelligentTieringId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class IntelligentTieringConfiguration(
    id: IntelligentTieringId,
    filter: Option[zio.aws.s3.model.IntelligentTieringFilter] = None,
    status: zio.aws.s3.model.IntelligentTieringStatus,
    tierings: Iterable[zio.aws.s3.model.Tiering]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.IntelligentTieringConfiguration = {
    import IntelligentTieringConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.IntelligentTieringConfiguration
      .builder()
      .id(IntelligentTieringId.unwrap(id): java.lang.String)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .status(status.unwrap)
      .tierings(tierings.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.IntelligentTieringConfiguration.ReadOnly =
    zio.aws.s3.model.IntelligentTieringConfiguration.wrap(buildAwsValue())
}
object IntelligentTieringConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.IntelligentTieringConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.IntelligentTieringConfiguration =
      zio.aws.s3.model.IntelligentTieringConfiguration(
        id,
        filter.map(value => value.asEditable),
        status,
        tierings.map { item =>
          item.asEditable
        }
      )
    def id: IntelligentTieringId
    def filter: Option[zio.aws.s3.model.IntelligentTieringFilter.ReadOnly]
    def status: zio.aws.s3.model.IntelligentTieringStatus
    def tierings: List[zio.aws.s3.model.Tiering.ReadOnly]
    def getId: ZIO[Any, Nothing, IntelligentTieringId] = ZIO.succeed(id)
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.IntelligentTieringFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.s3.model.IntelligentTieringStatus] =
      ZIO.succeed(status)
    def getTierings
        : ZIO[Any, Nothing, List[zio.aws.s3.model.Tiering.ReadOnly]] =
      ZIO.succeed(tierings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.IntelligentTieringConfiguration
  ) extends zio.aws.s3.model.IntelligentTieringConfiguration.ReadOnly {
    override val id: IntelligentTieringId =
      zio.aws.s3.model.primitives.IntelligentTieringId(impl.id())
    override val filter
        : Option[zio.aws.s3.model.IntelligentTieringFilter.ReadOnly] = scala
      .Option(impl.filter())
      .map(value => zio.aws.s3.model.IntelligentTieringFilter.wrap(value))
    override val status: zio.aws.s3.model.IntelligentTieringStatus =
      zio.aws.s3.model.IntelligentTieringStatus.wrap(impl.status())
    override val tierings: List[zio.aws.s3.model.Tiering.ReadOnly] = impl
      .tierings()
      .asScala
      .map { item =>
        zio.aws.s3.model.Tiering.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.IntelligentTieringConfiguration
  ): zio.aws.s3.model.IntelligentTieringConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
