package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InventoryEncryption(
    sses3: Option[zio.aws.s3.model.SSES3] = None,
    ssekms: Option[zio.aws.s3.model.SSEKMS] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.InventoryEncryption = {
    import InventoryEncryption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.InventoryEncryption
      .builder()
      .optionallyWith(sses3.map(value => value.buildAwsValue()))(_.sses3)
      .optionallyWith(ssekms.map(value => value.buildAwsValue()))(_.ssekms)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.InventoryEncryption.ReadOnly =
    zio.aws.s3.model.InventoryEncryption.wrap(buildAwsValue())
}
object InventoryEncryption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.InventoryEncryption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.InventoryEncryption =
      zio.aws.s3.model.InventoryEncryption(
        sses3.map(value => value.asEditable),
        ssekms.map(value => value.asEditable)
      )
    def sses3: Option[zio.aws.s3.model.SSES3.ReadOnly]
    def ssekms: Option[zio.aws.s3.model.SSEKMS.ReadOnly]
    def getSses3: ZIO[Any, AwsError, zio.aws.s3.model.SSES3.ReadOnly] =
      AwsError.unwrapOptionField("sses3", sses3)
    def getSsekms: ZIO[Any, AwsError, zio.aws.s3.model.SSEKMS.ReadOnly] =
      AwsError.unwrapOptionField("ssekms", ssekms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.InventoryEncryption
  ) extends zio.aws.s3.model.InventoryEncryption.ReadOnly {
    override val sses3: Option[zio.aws.s3.model.SSES3.ReadOnly] = scala
      .Option(impl.sses3())
      .map(value => zio.aws.s3.model.SSES3.wrap(value))
    override val ssekms: Option[zio.aws.s3.model.SSEKMS.ReadOnly] = scala
      .Option(impl.ssekms())
      .map(value => zio.aws.s3.model.SSEKMS.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.InventoryEncryption
  ): zio.aws.s3.model.InventoryEncryption.ReadOnly = new Wrapper(impl)
}
