package zio.aws.s3.model
import zio.aws.s3.model.primitives.Prefix
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class InventoryFilter(prefix: Prefix) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.InventoryFilter = {
    import InventoryFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.InventoryFilter
      .builder()
      .prefix(Prefix.unwrap(prefix): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.InventoryFilter.ReadOnly =
    zio.aws.s3.model.InventoryFilter.wrap(buildAwsValue())
}
object InventoryFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.InventoryFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.InventoryFilter =
      zio.aws.s3.model.InventoryFilter(prefix)
    def prefix: Prefix
    def getPrefix: ZIO[Any, Nothing, Prefix] = ZIO.succeed(prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.InventoryFilter
  ) extends zio.aws.s3.model.InventoryFilter.ReadOnly {
    override val prefix: Prefix =
      zio.aws.s3.model.primitives.Prefix(impl.prefix())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.InventoryFilter
  ): zio.aws.s3.model.InventoryFilter.ReadOnly = new Wrapper(impl)
}
