package zio.aws.s3.model
import scala.jdk.CollectionConverters.*
sealed trait InventoryIncludedObjectVersions {
  def unwrap
      : software.amazon.awssdk.services.s3.model.InventoryIncludedObjectVersions
}
object InventoryIncludedObjectVersions {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.InventoryIncludedObjectVersions
  ): zio.aws.s3.model.InventoryIncludedObjectVersions = value match {
    case software.amazon.awssdk.services.s3.model.InventoryIncludedObjectVersions.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.InventoryIncludedObjectVersions.ALL =>
      val r = All
      r
    case software.amazon.awssdk.services.s3.model.InventoryIncludedObjectVersions.CURRENT =>
      val r = Current
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3.model.InventoryIncludedObjectVersions {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.InventoryIncludedObjectVersions =
      software.amazon.awssdk.services.s3.model.InventoryIncludedObjectVersions.UNKNOWN_TO_SDK_VERSION
  }
  case object All extends zio.aws.s3.model.InventoryIncludedObjectVersions {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.InventoryIncludedObjectVersions =
      software.amazon.awssdk.services.s3.model.InventoryIncludedObjectVersions.ALL
  }
  case object Current extends zio.aws.s3.model.InventoryIncludedObjectVersions {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.InventoryIncludedObjectVersions =
      software.amazon.awssdk.services.s3.model.InventoryIncludedObjectVersions.CURRENT
  }
}
