package zio.aws.s3.model
import zio.aws.s3.model.primitives.{Prefix, BucketName, AccountId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InventoryS3BucketDestination(
    accountId: Option[AccountId] = None,
    bucket: BucketName,
    format: zio.aws.s3.model.InventoryFormat,
    prefix: Option[Prefix] = None,
    encryption: Option[zio.aws.s3.model.InventoryEncryption] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.InventoryS3BucketDestination = {
    import InventoryS3BucketDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.InventoryS3BucketDestination
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .format(format.unwrap)
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.InventoryS3BucketDestination.ReadOnly =
    zio.aws.s3.model.InventoryS3BucketDestination.wrap(buildAwsValue())
}
object InventoryS3BucketDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.InventoryS3BucketDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.InventoryS3BucketDestination =
      zio.aws.s3.model.InventoryS3BucketDestination(
        accountId.map(value => value),
        bucket,
        format,
        prefix.map(value => value),
        encryption.map(value => value.asEditable)
      )
    def accountId: Option[AccountId]
    def bucket: BucketName
    def format: zio.aws.s3.model.InventoryFormat
    def prefix: Option[Prefix]
    def encryption: Option[zio.aws.s3.model.InventoryEncryption.ReadOnly]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getFormat: ZIO[Any, Nothing, zio.aws.s3.model.InventoryFormat] =
      ZIO.succeed(format)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getEncryption
        : ZIO[Any, AwsError, zio.aws.s3.model.InventoryEncryption.ReadOnly] =
      AwsError.unwrapOptionField("encryption", encryption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.InventoryS3BucketDestination
  ) extends zio.aws.s3.model.InventoryS3BucketDestination.ReadOnly {
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val format: zio.aws.s3.model.InventoryFormat =
      zio.aws.s3.model.InventoryFormat.wrap(impl.format())
    override val prefix: Option[Prefix] = scala
      .Option(impl.prefix())
      .map(value => zio.aws.s3.model.primitives.Prefix(value))
    override val encryption
        : Option[zio.aws.s3.model.InventoryEncryption.ReadOnly] = scala
      .Option(impl.encryption())
      .map(value => zio.aws.s3.model.InventoryEncryption.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.InventoryS3BucketDestination
  ): zio.aws.s3.model.InventoryS3BucketDestination.ReadOnly = new Wrapper(impl)
}
