package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  ObjectSizeLessThanBytes,
  ObjectSizeGreaterThanBytes,
  Prefix
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LifecycleRuleFilter(
    prefix: Option[Prefix] = None,
    tag: Option[zio.aws.s3.model.Tag] = None,
    objectSizeGreaterThan: Option[ObjectSizeGreaterThanBytes] = None,
    objectSizeLessThan: Option[ObjectSizeLessThanBytes] = None,
    and: Option[zio.aws.s3.model.LifecycleRuleAndOperator] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.LifecycleRuleFilter = {
    import LifecycleRuleFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.LifecycleRuleFilter
      .builder()
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(tag.map(value => value.buildAwsValue()))(_.tag)
      .optionallyWith(
        objectSizeGreaterThan.map(value =>
          ObjectSizeGreaterThanBytes.unwrap(value): java.lang.Long
        )
      )(_.objectSizeGreaterThan)
      .optionallyWith(
        objectSizeLessThan.map(value =>
          ObjectSizeLessThanBytes.unwrap(value): java.lang.Long
        )
      )(_.objectSizeLessThan)
      .optionallyWith(and.map(value => value.buildAwsValue()))(_.and)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.LifecycleRuleFilter.ReadOnly =
    zio.aws.s3.model.LifecycleRuleFilter.wrap(buildAwsValue())
}
object LifecycleRuleFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.LifecycleRuleFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.LifecycleRuleFilter =
      zio.aws.s3.model.LifecycleRuleFilter(
        prefix.map(value => value),
        tag.map(value => value.asEditable),
        objectSizeGreaterThan.map(value => value),
        objectSizeLessThan.map(value => value),
        and.map(value => value.asEditable)
      )
    def prefix: Option[Prefix]
    def tag: Option[zio.aws.s3.model.Tag.ReadOnly]
    def objectSizeGreaterThan: Option[ObjectSizeGreaterThanBytes]
    def objectSizeLessThan: Option[ObjectSizeLessThanBytes]
    def and: Option[zio.aws.s3.model.LifecycleRuleAndOperator.ReadOnly]
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getTag: ZIO[Any, AwsError, zio.aws.s3.model.Tag.ReadOnly] =
      AwsError.unwrapOptionField("tag", tag)
    def getObjectSizeGreaterThan
        : ZIO[Any, AwsError, ObjectSizeGreaterThanBytes] =
      AwsError.unwrapOptionField("objectSizeGreaterThan", objectSizeGreaterThan)
    def getObjectSizeLessThan: ZIO[Any, AwsError, ObjectSizeLessThanBytes] =
      AwsError.unwrapOptionField("objectSizeLessThan", objectSizeLessThan)
    def getAnd: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.LifecycleRuleAndOperator.ReadOnly
    ] = AwsError.unwrapOptionField("and", and)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.LifecycleRuleFilter
  ) extends zio.aws.s3.model.LifecycleRuleFilter.ReadOnly {
    override val prefix: Option[Prefix] = scala
      .Option(impl.prefix())
      .map(value => zio.aws.s3.model.primitives.Prefix(value))
    override val tag: Option[zio.aws.s3.model.Tag.ReadOnly] =
      scala.Option(impl.tag()).map(value => zio.aws.s3.model.Tag.wrap(value))
    override val objectSizeGreaterThan: Option[ObjectSizeGreaterThanBytes] =
      scala
        .Option(impl.objectSizeGreaterThan())
        .map(value =>
          zio.aws.s3.model.primitives.ObjectSizeGreaterThanBytes(value)
        )
    override val objectSizeLessThan: Option[ObjectSizeLessThanBytes] = scala
      .Option(impl.objectSizeLessThan())
      .map(value => zio.aws.s3.model.primitives.ObjectSizeLessThanBytes(value))
    override val and
        : Option[zio.aws.s3.model.LifecycleRuleAndOperator.ReadOnly] = scala
      .Option(impl.and())
      .map(value => zio.aws.s3.model.LifecycleRuleAndOperator.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.LifecycleRuleFilter
  ): zio.aws.s3.model.LifecycleRuleFilter.ReadOnly = new Wrapper(impl)
}
