package zio.aws.s3.model
import zio.aws.s3.model.primitives.{AccountId, Token, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListBucketAnalyticsConfigurationsRequest(
    bucket: BucketName,
    continuationToken: Option[Token] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsRequest = {
    import ListBucketAnalyticsConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        continuationToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.continuationToken)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : zio.aws.s3.model.ListBucketAnalyticsConfigurationsRequest.ReadOnly =
    zio.aws.s3.model.ListBucketAnalyticsConfigurationsRequest
      .wrap(buildAwsValue())
}
object ListBucketAnalyticsConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ListBucketAnalyticsConfigurationsRequest =
      zio.aws.s3.model.ListBucketAnalyticsConfigurationsRequest(
        bucket,
        continuationToken.map(value => value),
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def continuationToken: Option[Token]
    def expectedBucketOwner: Option[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getContinuationToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("continuationToken", continuationToken)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsRequest
  ) extends zio.aws.s3.model.ListBucketAnalyticsConfigurationsRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val continuationToken: Option[Token] = scala
      .Option(impl.continuationToken())
      .map(value => zio.aws.s3.model.primitives.Token(value))
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsRequest
  ): zio.aws.s3.model.ListBucketAnalyticsConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
