package zio.aws.s3.model
import zio.aws.s3.model.primitives.{NextToken, IsTruncated, Token}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListBucketInventoryConfigurationsResponse(
    continuationToken: Option[Token] = None,
    inventoryConfigurationList: Option[
      Iterable[zio.aws.s3.model.InventoryConfiguration]
    ] = None,
    isTruncated: Option[IsTruncated] = None,
    nextContinuationToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListBucketInventoryConfigurationsResponse = {
    import ListBucketInventoryConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListBucketInventoryConfigurationsResponse
      .builder()
      .optionallyWith(
        continuationToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.continuationToken)
      .optionallyWith(
        inventoryConfigurationList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inventoryConfigurationList)
      .optionallyWith(
        isTruncated.map(value => IsTruncated.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        nextContinuationToken.map(value =>
          NextToken.unwrap(value): java.lang.String
        )
      )(_.nextContinuationToken)
      .build()
  }
  def asReadOnly
      : zio.aws.s3.model.ListBucketInventoryConfigurationsResponse.ReadOnly =
    zio.aws.s3.model.ListBucketInventoryConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListBucketInventoryConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListBucketInventoryConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ListBucketInventoryConfigurationsResponse =
      zio.aws.s3.model.ListBucketInventoryConfigurationsResponse(
        continuationToken.map(value => value),
        inventoryConfigurationList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        isTruncated.map(value => value),
        nextContinuationToken.map(value => value)
      )
    def continuationToken: Option[Token]
    def inventoryConfigurationList
        : Option[List[zio.aws.s3.model.InventoryConfiguration.ReadOnly]]
    def isTruncated: Option[IsTruncated]
    def nextContinuationToken: Option[NextToken]
    def getContinuationToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("continuationToken", continuationToken)
    def getInventoryConfigurationList: ZIO[Any, AwsError, List[
      zio.aws.s3.model.InventoryConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "inventoryConfigurationList",
      inventoryConfigurationList
    )
    def getIsTruncated: ZIO[Any, AwsError, IsTruncated] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getNextContinuationToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextContinuationToken", nextContinuationToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListBucketInventoryConfigurationsResponse
  ) extends zio.aws.s3.model.ListBucketInventoryConfigurationsResponse.ReadOnly {
    override val continuationToken: Option[Token] = scala
      .Option(impl.continuationToken())
      .map(value => zio.aws.s3.model.primitives.Token(value))
    override val inventoryConfigurationList
        : Option[List[zio.aws.s3.model.InventoryConfiguration.ReadOnly]] = scala
      .Option(impl.inventoryConfigurationList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3.model.InventoryConfiguration.wrap(item)
        }.toList
      )
    override val isTruncated: Option[IsTruncated] = scala
      .Option(impl.isTruncated())
      .map(value => zio.aws.s3.model.primitives.IsTruncated(value))
    override val nextContinuationToken: Option[NextToken] = scala
      .Option(impl.nextContinuationToken())
      .map(value => zio.aws.s3.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListBucketInventoryConfigurationsResponse
  ): zio.aws.s3.model.ListBucketInventoryConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
