package zio.aws.s3.model
import zio.aws.s3.model.primitives.{NextToken, Token, IsTruncated}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListBucketMetricsConfigurationsResponse(
    isTruncated: Option[IsTruncated] = None,
    continuationToken: Option[Token] = None,
    nextContinuationToken: Option[NextToken] = None,
    metricsConfigurationList: Option[
      Iterable[zio.aws.s3.model.MetricsConfiguration]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListBucketMetricsConfigurationsResponse = {
    import ListBucketMetricsConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListBucketMetricsConfigurationsResponse
      .builder()
      .optionallyWith(
        isTruncated.map(value => IsTruncated.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        continuationToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.continuationToken)
      .optionallyWith(
        nextContinuationToken.map(value =>
          NextToken.unwrap(value): java.lang.String
        )
      )(_.nextContinuationToken)
      .optionallyWith(
        metricsConfigurationList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricsConfigurationList)
      .build()
  }
  def asReadOnly
      : zio.aws.s3.model.ListBucketMetricsConfigurationsResponse.ReadOnly =
    zio.aws.s3.model.ListBucketMetricsConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListBucketMetricsConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListBucketMetricsConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ListBucketMetricsConfigurationsResponse =
      zio.aws.s3.model.ListBucketMetricsConfigurationsResponse(
        isTruncated.map(value => value),
        continuationToken.map(value => value),
        nextContinuationToken.map(value => value),
        metricsConfigurationList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def isTruncated: Option[IsTruncated]
    def continuationToken: Option[Token]
    def nextContinuationToken: Option[NextToken]
    def metricsConfigurationList
        : Option[List[zio.aws.s3.model.MetricsConfiguration.ReadOnly]]
    def getIsTruncated: ZIO[Any, AwsError, IsTruncated] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getContinuationToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("continuationToken", continuationToken)
    def getNextContinuationToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextContinuationToken", nextContinuationToken)
    def getMetricsConfigurationList: ZIO[Any, AwsError, List[
      zio.aws.s3.model.MetricsConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "metricsConfigurationList",
      metricsConfigurationList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListBucketMetricsConfigurationsResponse
  ) extends zio.aws.s3.model.ListBucketMetricsConfigurationsResponse.ReadOnly {
    override val isTruncated: Option[IsTruncated] = scala
      .Option(impl.isTruncated())
      .map(value => zio.aws.s3.model.primitives.IsTruncated(value))
    override val continuationToken: Option[Token] = scala
      .Option(impl.continuationToken())
      .map(value => zio.aws.s3.model.primitives.Token(value))
    override val nextContinuationToken: Option[NextToken] = scala
      .Option(impl.nextContinuationToken())
      .map(value => zio.aws.s3.model.primitives.NextToken(value))
    override val metricsConfigurationList
        : Option[List[zio.aws.s3.model.MetricsConfiguration.ReadOnly]] = scala
      .Option(impl.metricsConfigurationList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3.model.MetricsConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListBucketMetricsConfigurationsResponse
  ): zio.aws.s3.model.ListBucketMetricsConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
