package zio.aws.s3.model
import java.lang.Integer
import zio.aws.s3.model.primitives.{
  MaxKeys,
  Prefix,
  AccountId,
  VersionIdMarker,
  Delimiter,
  BucketName,
  KeyMarker
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListObjectVersionsRequest(
    bucket: BucketName,
    delimiter: Option[Delimiter] = None,
    encodingType: Option[zio.aws.s3.model.EncodingType] = None,
    keyMarker: Option[KeyMarker] = None,
    maxKeys: Option[MaxKeys] = None,
    prefix: Option[Prefix] = None,
    versionIdMarker: Option[VersionIdMarker] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest = {
    import ListObjectVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        delimiter.map(value => Delimiter.unwrap(value): java.lang.String)
      )(_.delimiter)
      .optionallyWith(encodingType.map(value => value.unwrap))(_.encodingType)
      .optionallyWith(
        keyMarker.map(value => KeyMarker.unwrap(value): java.lang.String)
      )(_.keyMarker)
      .optionallyWith(maxKeys.map(value => MaxKeys.unwrap(value): Integer))(
        _.maxKeys
      )
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(
        versionIdMarker.map(value =>
          VersionIdMarker.unwrap(value): java.lang.String
        )
      )(_.versionIdMarker)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ListObjectVersionsRequest.ReadOnly =
    zio.aws.s3.model.ListObjectVersionsRequest.wrap(buildAwsValue())
}
object ListObjectVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ListObjectVersionsRequest =
      zio.aws.s3.model.ListObjectVersionsRequest(
        bucket,
        delimiter.map(value => value),
        encodingType.map(value => value),
        keyMarker.map(value => value),
        maxKeys.map(value => value),
        prefix.map(value => value),
        versionIdMarker.map(value => value),
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def delimiter: Option[Delimiter]
    def encodingType: Option[zio.aws.s3.model.EncodingType]
    def keyMarker: Option[KeyMarker]
    def maxKeys: Option[MaxKeys]
    def prefix: Option[Prefix]
    def versionIdMarker: Option[VersionIdMarker]
    def expectedBucketOwner: Option[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getDelimiter: ZIO[Any, AwsError, Delimiter] =
      AwsError.unwrapOptionField("delimiter", delimiter)
    def getEncodingType: ZIO[Any, AwsError, zio.aws.s3.model.EncodingType] =
      AwsError.unwrapOptionField("encodingType", encodingType)
    def getKeyMarker: ZIO[Any, AwsError, KeyMarker] =
      AwsError.unwrapOptionField("keyMarker", keyMarker)
    def getMaxKeys: ZIO[Any, AwsError, MaxKeys] =
      AwsError.unwrapOptionField("maxKeys", maxKeys)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getVersionIdMarker: ZIO[Any, AwsError, VersionIdMarker] =
      AwsError.unwrapOptionField("versionIdMarker", versionIdMarker)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest
  ) extends zio.aws.s3.model.ListObjectVersionsRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val delimiter: Option[Delimiter] = scala
      .Option(impl.delimiter())
      .map(value => zio.aws.s3.model.primitives.Delimiter(value))
    override val encodingType: Option[zio.aws.s3.model.EncodingType] = scala
      .Option(impl.encodingType())
      .map(value => zio.aws.s3.model.EncodingType.wrap(value))
    override val keyMarker: Option[KeyMarker] = scala
      .Option(impl.keyMarker())
      .map(value => zio.aws.s3.model.primitives.KeyMarker(value))
    override val maxKeys: Option[MaxKeys] = scala
      .Option(impl.maxKeys())
      .map(value => zio.aws.s3.model.primitives.MaxKeys(value))
    override val prefix: Option[Prefix] = scala
      .Option(impl.prefix())
      .map(value => zio.aws.s3.model.primitives.Prefix(value))
    override val versionIdMarker: Option[VersionIdMarker] = scala
      .Option(impl.versionIdMarker())
      .map(value => zio.aws.s3.model.primitives.VersionIdMarker(value))
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest
  ): zio.aws.s3.model.ListObjectVersionsRequest.ReadOnly = new Wrapper(impl)
}
