package zio.aws.s3.model
import java.lang.Integer
import zio.aws.s3.model.primitives.{
  MaxKeys,
  NextVersionIdMarker,
  Prefix,
  VersionIdMarker,
  Delimiter,
  BucketName,
  KeyMarker,
  IsTruncated,
  NextKeyMarker
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListObjectVersionsResponse(
    isTruncated: Option[IsTruncated] = None,
    keyMarker: Option[KeyMarker] = None,
    versionIdMarker: Option[VersionIdMarker] = None,
    nextKeyMarker: Option[NextKeyMarker] = None,
    nextVersionIdMarker: Option[NextVersionIdMarker] = None,
    versions: Option[Iterable[zio.aws.s3.model.ObjectVersion]] = None,
    deleteMarkers: Option[Iterable[zio.aws.s3.model.DeleteMarkerEntry]] = None,
    name: Option[BucketName] = None,
    prefix: Option[Prefix] = None,
    delimiter: Option[Delimiter] = None,
    maxKeys: Option[MaxKeys] = None,
    commonPrefixes: Option[Iterable[zio.aws.s3.model.CommonPrefix]] = None,
    encodingType: Option[zio.aws.s3.model.EncodingType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse = {
    import ListObjectVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse
      .builder()
      .optionallyWith(
        isTruncated.map(value => IsTruncated.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        keyMarker.map(value => KeyMarker.unwrap(value): java.lang.String)
      )(_.keyMarker)
      .optionallyWith(
        versionIdMarker.map(value =>
          VersionIdMarker.unwrap(value): java.lang.String
        )
      )(_.versionIdMarker)
      .optionallyWith(
        nextKeyMarker.map(value =>
          NextKeyMarker.unwrap(value): java.lang.String
        )
      )(_.nextKeyMarker)
      .optionallyWith(
        nextVersionIdMarker.map(value =>
          NextVersionIdMarker.unwrap(value): java.lang.String
        )
      )(_.nextVersionIdMarker)
      .optionallyWith(
        versions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.versions)
      .optionallyWith(
        deleteMarkers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deleteMarkers)
      .optionallyWith(
        name.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(
        delimiter.map(value => Delimiter.unwrap(value): java.lang.String)
      )(_.delimiter)
      .optionallyWith(maxKeys.map(value => MaxKeys.unwrap(value): Integer))(
        _.maxKeys
      )
      .optionallyWith(
        commonPrefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.commonPrefixes)
      .optionallyWith(encodingType.map(value => value.unwrap))(_.encodingType)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ListObjectVersionsResponse.ReadOnly =
    zio.aws.s3.model.ListObjectVersionsResponse.wrap(buildAwsValue())
}
object ListObjectVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ListObjectVersionsResponse =
      zio.aws.s3.model.ListObjectVersionsResponse(
        isTruncated.map(value => value),
        keyMarker.map(value => value),
        versionIdMarker.map(value => value),
        nextKeyMarker.map(value => value),
        nextVersionIdMarker.map(value => value),
        versions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        deleteMarkers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name.map(value => value),
        prefix.map(value => value),
        delimiter.map(value => value),
        maxKeys.map(value => value),
        commonPrefixes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        encodingType.map(value => value)
      )
    def isTruncated: Option[IsTruncated]
    def keyMarker: Option[KeyMarker]
    def versionIdMarker: Option[VersionIdMarker]
    def nextKeyMarker: Option[NextKeyMarker]
    def nextVersionIdMarker: Option[NextVersionIdMarker]
    def versions: Option[List[zio.aws.s3.model.ObjectVersion.ReadOnly]]
    def deleteMarkers: Option[List[zio.aws.s3.model.DeleteMarkerEntry.ReadOnly]]
    def name: Option[BucketName]
    def prefix: Option[Prefix]
    def delimiter: Option[Delimiter]
    def maxKeys: Option[MaxKeys]
    def commonPrefixes: Option[List[zio.aws.s3.model.CommonPrefix.ReadOnly]]
    def encodingType: Option[zio.aws.s3.model.EncodingType]
    def getIsTruncated: ZIO[Any, AwsError, IsTruncated] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getKeyMarker: ZIO[Any, AwsError, KeyMarker] =
      AwsError.unwrapOptionField("keyMarker", keyMarker)
    def getVersionIdMarker: ZIO[Any, AwsError, VersionIdMarker] =
      AwsError.unwrapOptionField("versionIdMarker", versionIdMarker)
    def getNextKeyMarker: ZIO[Any, AwsError, NextKeyMarker] =
      AwsError.unwrapOptionField("nextKeyMarker", nextKeyMarker)
    def getNextVersionIdMarker: ZIO[Any, AwsError, NextVersionIdMarker] =
      AwsError.unwrapOptionField("nextVersionIdMarker", nextVersionIdMarker)
    def getVersions
        : ZIO[Any, AwsError, List[zio.aws.s3.model.ObjectVersion.ReadOnly]] =
      AwsError.unwrapOptionField("versions", versions)
    def getDeleteMarkers: ZIO[Any, AwsError, List[
      zio.aws.s3.model.DeleteMarkerEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("deleteMarkers", deleteMarkers)
    def getName: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("name", name)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getDelimiter: ZIO[Any, AwsError, Delimiter] =
      AwsError.unwrapOptionField("delimiter", delimiter)
    def getMaxKeys: ZIO[Any, AwsError, MaxKeys] =
      AwsError.unwrapOptionField("maxKeys", maxKeys)
    def getCommonPrefixes
        : ZIO[Any, AwsError, List[zio.aws.s3.model.CommonPrefix.ReadOnly]] =
      AwsError.unwrapOptionField("commonPrefixes", commonPrefixes)
    def getEncodingType: ZIO[Any, AwsError, zio.aws.s3.model.EncodingType] =
      AwsError.unwrapOptionField("encodingType", encodingType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse
  ) extends zio.aws.s3.model.ListObjectVersionsResponse.ReadOnly {
    override val isTruncated: Option[IsTruncated] = scala
      .Option(impl.isTruncated())
      .map(value => zio.aws.s3.model.primitives.IsTruncated(value))
    override val keyMarker: Option[KeyMarker] = scala
      .Option(impl.keyMarker())
      .map(value => zio.aws.s3.model.primitives.KeyMarker(value))
    override val versionIdMarker: Option[VersionIdMarker] = scala
      .Option(impl.versionIdMarker())
      .map(value => zio.aws.s3.model.primitives.VersionIdMarker(value))
    override val nextKeyMarker: Option[NextKeyMarker] = scala
      .Option(impl.nextKeyMarker())
      .map(value => zio.aws.s3.model.primitives.NextKeyMarker(value))
    override val nextVersionIdMarker: Option[NextVersionIdMarker] = scala
      .Option(impl.nextVersionIdMarker())
      .map(value => zio.aws.s3.model.primitives.NextVersionIdMarker(value))
    override val versions
        : Option[List[zio.aws.s3.model.ObjectVersion.ReadOnly]] = scala
      .Option(impl.versions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3.model.ObjectVersion.wrap(item)
        }.toList
      )
    override val deleteMarkers
        : Option[List[zio.aws.s3.model.DeleteMarkerEntry.ReadOnly]] = scala
      .Option(impl.deleteMarkers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3.model.DeleteMarkerEntry.wrap(item)
        }.toList
      )
    override val name: Option[BucketName] = scala
      .Option(impl.name())
      .map(value => zio.aws.s3.model.primitives.BucketName(value))
    override val prefix: Option[Prefix] = scala
      .Option(impl.prefix())
      .map(value => zio.aws.s3.model.primitives.Prefix(value))
    override val delimiter: Option[Delimiter] = scala
      .Option(impl.delimiter())
      .map(value => zio.aws.s3.model.primitives.Delimiter(value))
    override val maxKeys: Option[MaxKeys] = scala
      .Option(impl.maxKeys())
      .map(value => zio.aws.s3.model.primitives.MaxKeys(value))
    override val commonPrefixes
        : Option[List[zio.aws.s3.model.CommonPrefix.ReadOnly]] = scala
      .Option(impl.commonPrefixes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3.model.CommonPrefix.wrap(item)
        }.toList
      )
    override val encodingType: Option[zio.aws.s3.model.EncodingType] = scala
      .Option(impl.encodingType())
      .map(value => zio.aws.s3.model.EncodingType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse
  ): zio.aws.s3.model.ListObjectVersionsResponse.ReadOnly = new Wrapper(impl)
}
