package zio.aws.s3.model
import java.lang.Integer
import zio.aws.s3.model.primitives.{
  MaxKeys,
  Token,
  Prefix,
  AccountId,
  FetchOwner,
  StartAfter,
  Delimiter,
  BucketName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListObjectsV2Request(
    bucket: BucketName,
    delimiter: Option[Delimiter] = None,
    encodingType: Option[zio.aws.s3.model.EncodingType] = None,
    maxKeys: Option[MaxKeys] = None,
    prefix: Option[Prefix] = None,
    continuationToken: Option[Token] = None,
    fetchOwner: Option[FetchOwner] = None,
    startAfter: Option[StartAfter] = None,
    requestPayer: Option[zio.aws.s3.model.RequestPayer] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListObjectsV2Request = {
    import ListObjectsV2Request.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListObjectsV2Request
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        delimiter.map(value => Delimiter.unwrap(value): java.lang.String)
      )(_.delimiter)
      .optionallyWith(encodingType.map(value => value.unwrap))(_.encodingType)
      .optionallyWith(maxKeys.map(value => MaxKeys.unwrap(value): Integer))(
        _.maxKeys
      )
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(
        continuationToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.continuationToken)
      .optionallyWith(
        fetchOwner.map(value => FetchOwner.unwrap(value): java.lang.Boolean)
      )(_.fetchOwner)
      .optionallyWith(
        startAfter.map(value => StartAfter.unwrap(value): java.lang.String)
      )(_.startAfter)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ListObjectsV2Request.ReadOnly =
    zio.aws.s3.model.ListObjectsV2Request.wrap(buildAwsValue())
}
object ListObjectsV2Request {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListObjectsV2Request
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ListObjectsV2Request =
      zio.aws.s3.model.ListObjectsV2Request(
        bucket,
        delimiter.map(value => value),
        encodingType.map(value => value),
        maxKeys.map(value => value),
        prefix.map(value => value),
        continuationToken.map(value => value),
        fetchOwner.map(value => value),
        startAfter.map(value => value),
        requestPayer.map(value => value),
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def delimiter: Option[Delimiter]
    def encodingType: Option[zio.aws.s3.model.EncodingType]
    def maxKeys: Option[MaxKeys]
    def prefix: Option[Prefix]
    def continuationToken: Option[Token]
    def fetchOwner: Option[FetchOwner]
    def startAfter: Option[StartAfter]
    def requestPayer: Option[zio.aws.s3.model.RequestPayer]
    def expectedBucketOwner: Option[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getDelimiter: ZIO[Any, AwsError, Delimiter] =
      AwsError.unwrapOptionField("delimiter", delimiter)
    def getEncodingType: ZIO[Any, AwsError, zio.aws.s3.model.EncodingType] =
      AwsError.unwrapOptionField("encodingType", encodingType)
    def getMaxKeys: ZIO[Any, AwsError, MaxKeys] =
      AwsError.unwrapOptionField("maxKeys", maxKeys)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getContinuationToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("continuationToken", continuationToken)
    def getFetchOwner: ZIO[Any, AwsError, FetchOwner] =
      AwsError.unwrapOptionField("fetchOwner", fetchOwner)
    def getStartAfter: ZIO[Any, AwsError, StartAfter] =
      AwsError.unwrapOptionField("startAfter", startAfter)
    def getRequestPayer: ZIO[Any, AwsError, zio.aws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayer)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListObjectsV2Request
  ) extends zio.aws.s3.model.ListObjectsV2Request.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val delimiter: Option[Delimiter] = scala
      .Option(impl.delimiter())
      .map(value => zio.aws.s3.model.primitives.Delimiter(value))
    override val encodingType: Option[zio.aws.s3.model.EncodingType] = scala
      .Option(impl.encodingType())
      .map(value => zio.aws.s3.model.EncodingType.wrap(value))
    override val maxKeys: Option[MaxKeys] = scala
      .Option(impl.maxKeys())
      .map(value => zio.aws.s3.model.primitives.MaxKeys(value))
    override val prefix: Option[Prefix] = scala
      .Option(impl.prefix())
      .map(value => zio.aws.s3.model.primitives.Prefix(value))
    override val continuationToken: Option[Token] = scala
      .Option(impl.continuationToken())
      .map(value => zio.aws.s3.model.primitives.Token(value))
    override val fetchOwner: Option[FetchOwner] = scala
      .Option(impl.fetchOwner())
      .map(value => zio.aws.s3.model.primitives.FetchOwner(value))
    override val startAfter: Option[StartAfter] = scala
      .Option(impl.startAfter())
      .map(value => zio.aws.s3.model.primitives.StartAfter(value))
    override val requestPayer: Option[zio.aws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => zio.aws.s3.model.RequestPayer.wrap(value))
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListObjectsV2Request
  ): zio.aws.s3.model.ListObjectsV2Request.ReadOnly = new Wrapper(impl)
}
