package zio.aws.s3.model
import java.lang.Integer
import zio.aws.s3.model.primitives.{
  MaxParts,
  AccountId,
  ObjectKey,
  BucketName,
  MultipartUploadId,
  PartNumberMarker
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListPartsRequest(
    bucket: BucketName,
    key: ObjectKey,
    maxParts: Option[MaxParts] = None,
    partNumberMarker: Option[PartNumberMarker] = None,
    uploadId: MultipartUploadId,
    requestPayer: Option[zio.aws.s3.model.RequestPayer] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListPartsRequest = {
    import ListPartsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListPartsRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .key(ObjectKey.unwrap(key): java.lang.String)
      .optionallyWith(maxParts.map(value => MaxParts.unwrap(value): Integer))(
        _.maxParts
      )
      .optionallyWith(
        partNumberMarker.map(value => PartNumberMarker.unwrap(value): Integer)
      )(_.partNumberMarker)
      .uploadId(MultipartUploadId.unwrap(uploadId): java.lang.String)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ListPartsRequest.ReadOnly =
    zio.aws.s3.model.ListPartsRequest.wrap(buildAwsValue())
}
object ListPartsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListPartsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ListPartsRequest =
      zio.aws.s3.model.ListPartsRequest(
        bucket,
        key,
        maxParts.map(value => value),
        partNumberMarker.map(value => value),
        uploadId,
        requestPayer.map(value => value),
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def key: ObjectKey
    def maxParts: Option[MaxParts]
    def partNumberMarker: Option[PartNumberMarker]
    def uploadId: MultipartUploadId
    def requestPayer: Option[zio.aws.s3.model.RequestPayer]
    def expectedBucketOwner: Option[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getKey: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(key)
    def getMaxParts: ZIO[Any, AwsError, MaxParts] =
      AwsError.unwrapOptionField("maxParts", maxParts)
    def getPartNumberMarker: ZIO[Any, AwsError, PartNumberMarker] =
      AwsError.unwrapOptionField("partNumberMarker", partNumberMarker)
    def getUploadId: ZIO[Any, Nothing, MultipartUploadId] =
      ZIO.succeed(uploadId)
    def getRequestPayer: ZIO[Any, AwsError, zio.aws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayer)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListPartsRequest
  ) extends zio.aws.s3.model.ListPartsRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val key: ObjectKey =
      zio.aws.s3.model.primitives.ObjectKey(impl.key())
    override val maxParts: Option[MaxParts] = scala
      .Option(impl.maxParts())
      .map(value => zio.aws.s3.model.primitives.MaxParts(value))
    override val partNumberMarker: Option[PartNumberMarker] = scala
      .Option(impl.partNumberMarker())
      .map(value => zio.aws.s3.model.primitives.PartNumberMarker(value))
    override val uploadId: MultipartUploadId =
      zio.aws.s3.model.primitives.MultipartUploadId(impl.uploadId())
    override val requestPayer: Option[zio.aws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => zio.aws.s3.model.RequestPayer.wrap(value))
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListPartsRequest
  ): zio.aws.s3.model.ListPartsRequest.ReadOnly = new Wrapper(impl)
}
