package zio.aws.s3.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{
  MaxParts,
  AbortRuleId,
  NextPartNumberMarker,
  ObjectKey,
  BucketName,
  AbortDate,
  MultipartUploadId,
  PartNumberMarker,
  IsTruncated
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListPartsResponse(
    abortDate: Option[AbortDate] = None,
    abortRuleId: Option[AbortRuleId] = None,
    bucket: Option[BucketName] = None,
    key: Option[ObjectKey] = None,
    uploadId: Option[MultipartUploadId] = None,
    partNumberMarker: Option[PartNumberMarker] = None,
    nextPartNumberMarker: Option[NextPartNumberMarker] = None,
    maxParts: Option[MaxParts] = None,
    isTruncated: Option[IsTruncated] = None,
    parts: Option[Iterable[zio.aws.s3.model.Part]] = None,
    initiator: Option[zio.aws.s3.model.Initiator] = None,
    owner: Option[zio.aws.s3.model.Owner] = None,
    storageClass: Option[zio.aws.s3.model.StorageClass] = None,
    requestCharged: Option[zio.aws.s3.model.RequestCharged] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListPartsResponse = {
    import ListPartsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListPartsResponse
      .builder()
      .optionallyWith(abortDate.map(value => AbortDate.unwrap(value): Instant))(
        _.abortDate
      )
      .optionallyWith(
        abortRuleId.map(value => AbortRuleId.unwrap(value): java.lang.String)
      )(_.abortRuleId)
      .optionallyWith(
        bucket.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(
        key.map(value => ObjectKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        uploadId.map(value => MultipartUploadId.unwrap(value): java.lang.String)
      )(_.uploadId)
      .optionallyWith(
        partNumberMarker.map(value => PartNumberMarker.unwrap(value): Integer)
      )(_.partNumberMarker)
      .optionallyWith(
        nextPartNumberMarker.map(value =>
          NextPartNumberMarker.unwrap(value): Integer
        )
      )(_.nextPartNumberMarker)
      .optionallyWith(maxParts.map(value => MaxParts.unwrap(value): Integer))(
        _.maxParts
      )
      .optionallyWith(
        isTruncated.map(value => IsTruncated.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        parts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parts)
      .optionallyWith(initiator.map(value => value.buildAwsValue()))(
        _.initiator
      )
      .optionallyWith(owner.map(value => value.buildAwsValue()))(_.owner)
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ListPartsResponse.ReadOnly =
    zio.aws.s3.model.ListPartsResponse.wrap(buildAwsValue())
}
object ListPartsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListPartsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ListPartsResponse =
      zio.aws.s3.model.ListPartsResponse(
        abortDate.map(value => value),
        abortRuleId.map(value => value),
        bucket.map(value => value),
        key.map(value => value),
        uploadId.map(value => value),
        partNumberMarker.map(value => value),
        nextPartNumberMarker.map(value => value),
        maxParts.map(value => value),
        isTruncated.map(value => value),
        parts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        initiator.map(value => value.asEditable),
        owner.map(value => value.asEditable),
        storageClass.map(value => value),
        requestCharged.map(value => value)
      )
    def abortDate: Option[AbortDate]
    def abortRuleId: Option[AbortRuleId]
    def bucket: Option[BucketName]
    def key: Option[ObjectKey]
    def uploadId: Option[MultipartUploadId]
    def partNumberMarker: Option[PartNumberMarker]
    def nextPartNumberMarker: Option[NextPartNumberMarker]
    def maxParts: Option[MaxParts]
    def isTruncated: Option[IsTruncated]
    def parts: Option[List[zio.aws.s3.model.Part.ReadOnly]]
    def initiator: Option[zio.aws.s3.model.Initiator.ReadOnly]
    def owner: Option[zio.aws.s3.model.Owner.ReadOnly]
    def storageClass: Option[zio.aws.s3.model.StorageClass]
    def requestCharged: Option[zio.aws.s3.model.RequestCharged]
    def getAbortDate: ZIO[Any, AwsError, AbortDate] =
      AwsError.unwrapOptionField("abortDate", abortDate)
    def getAbortRuleId: ZIO[Any, AwsError, AbortRuleId] =
      AwsError.unwrapOptionField("abortRuleId", abortRuleId)
    def getBucket: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getKey: ZIO[Any, AwsError, ObjectKey] =
      AwsError.unwrapOptionField("key", key)
    def getUploadId: ZIO[Any, AwsError, MultipartUploadId] =
      AwsError.unwrapOptionField("uploadId", uploadId)
    def getPartNumberMarker: ZIO[Any, AwsError, PartNumberMarker] =
      AwsError.unwrapOptionField("partNumberMarker", partNumberMarker)
    def getNextPartNumberMarker: ZIO[Any, AwsError, NextPartNumberMarker] =
      AwsError.unwrapOptionField("nextPartNumberMarker", nextPartNumberMarker)
    def getMaxParts: ZIO[Any, AwsError, MaxParts] =
      AwsError.unwrapOptionField("maxParts", maxParts)
    def getIsTruncated: ZIO[Any, AwsError, IsTruncated] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getParts: ZIO[Any, AwsError, List[zio.aws.s3.model.Part.ReadOnly]] =
      AwsError.unwrapOptionField("parts", parts)
    def getInitiator: ZIO[Any, AwsError, zio.aws.s3.model.Initiator.ReadOnly] =
      AwsError.unwrapOptionField("initiator", initiator)
    def getOwner: ZIO[Any, AwsError, zio.aws.s3.model.Owner.ReadOnly] =
      AwsError.unwrapOptionField("owner", owner)
    def getStorageClass: ZIO[Any, AwsError, zio.aws.s3.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getRequestCharged: ZIO[Any, AwsError, zio.aws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestCharged)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListPartsResponse
  ) extends zio.aws.s3.model.ListPartsResponse.ReadOnly {
    override val abortDate: Option[AbortDate] = scala
      .Option(impl.abortDate())
      .map(value => zio.aws.s3.model.primitives.AbortDate(value))
    override val abortRuleId: Option[AbortRuleId] = scala
      .Option(impl.abortRuleId())
      .map(value => zio.aws.s3.model.primitives.AbortRuleId(value))
    override val bucket: Option[BucketName] = scala
      .Option(impl.bucket())
      .map(value => zio.aws.s3.model.primitives.BucketName(value))
    override val key: Option[ObjectKey] = scala
      .Option(impl.key())
      .map(value => zio.aws.s3.model.primitives.ObjectKey(value))
    override val uploadId: Option[MultipartUploadId] = scala
      .Option(impl.uploadId())
      .map(value => zio.aws.s3.model.primitives.MultipartUploadId(value))
    override val partNumberMarker: Option[PartNumberMarker] = scala
      .Option(impl.partNumberMarker())
      .map(value => zio.aws.s3.model.primitives.PartNumberMarker(value))
    override val nextPartNumberMarker: Option[NextPartNumberMarker] = scala
      .Option(impl.nextPartNumberMarker())
      .map(value => zio.aws.s3.model.primitives.NextPartNumberMarker(value))
    override val maxParts: Option[MaxParts] = scala
      .Option(impl.maxParts())
      .map(value => zio.aws.s3.model.primitives.MaxParts(value))
    override val isTruncated: Option[IsTruncated] = scala
      .Option(impl.isTruncated())
      .map(value => zio.aws.s3.model.primitives.IsTruncated(value))
    override val parts: Option[List[zio.aws.s3.model.Part.ReadOnly]] = scala
      .Option(impl.parts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3.model.Part.wrap(item)
        }.toList
      )
    override val initiator: Option[zio.aws.s3.model.Initiator.ReadOnly] = scala
      .Option(impl.initiator())
      .map(value => zio.aws.s3.model.Initiator.wrap(value))
    override val owner: Option[zio.aws.s3.model.Owner.ReadOnly] = scala
      .Option(impl.owner())
      .map(value => zio.aws.s3.model.Owner.wrap(value))
    override val storageClass: Option[zio.aws.s3.model.StorageClass] = scala
      .Option(impl.storageClass())
      .map(value => zio.aws.s3.model.StorageClass.wrap(value))
    override val requestCharged: Option[zio.aws.s3.model.RequestCharged] = scala
      .Option(impl.requestCharged())
      .map(value => zio.aws.s3.model.RequestCharged.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListPartsResponse
  ): zio.aws.s3.model.ListPartsResponse.ReadOnly = new Wrapper(impl)
}
